import useApiTabWazzupExtensionStore from "./useApiTabWazzupExtensionStore.js";

/** @param {Object} Допустимые типы каналов */
const channels = {
  whatsapp: "whatsapp",
  instagram: "instagram",
  tgapi: "tgapi", // обычный канал
  telegram: "telegram", // канал telegram bot
  avito: "avito",
  vk: "vk",
  wapi: "wapi",
  max: "max",
};

/**
 * Получить название канала по умолчанию.
 * @param {Object} item
 * @returns {string}
 */
function getDefaultName(item) {
  switch (item.transport) {
    case "whatsapp":
      return "Whatsapp";
    case "instagram":
      return "Instagram";
    case "tgapi":
      return "Telegram";
    case "telegram":
      return "Telegram bot";
    case "wapi":
      return "WhatsApp Business API";
    case "max":
      return "MAX";
  }

  if ("name" in item) return item.name;

  return "";
}

export default Pinia.defineStore("useChannelsTabWazzupExtensionStore", {
  state: () => ({
    channels: {},
    channel_statuses: {},
  }),

  getters: {
    getChannelStatus: (state) => (channel_id) => {
      switch (state.channel_statuses[channel_id] || "undefined") {
        case "active":
          return "активен";
        case "init":
          return "запускается";
        case "disabled":
          return "выключен";
        case "phoneUnavailable":
          return "нет связи с телефоном";
        case "qridle":
          return "необходимо отсканировать QR-код";
        case "openelsewhere":
          return "открыт в другом месте";
        case "notEnoughMoney":
          return "канал не оплачен";
        case "foreignphone":
          return "QR канала отсканирован не тем аккаунтом в мессенджере (с другим номером телефона)";
        case "unauthorized":
          return "не авторизован";
        case "waitForPassword":
          return "нужно ввести пароль для двухфакторной аутентификации";
      }
    },
  },

  actions: {
    getChannels() {
      const apiStore = useApiTabWazzupExtensionStore();

      fetch("https://api.wazzup24.com/v3/channels", {
        method: "GET",
        redirect: "follow",
        headers: {
          Authorization: `Bearer ${apiStore.api_key}`,
          "Content-Type": "application/json",
        },
      })
        .then((response) => response.json())
        .then((result) => {
          if (result instanceof Array) {
            let channel_statuses = {};

            result.forEach((item) => {
              if (
                item.transport in channels &&
                !(item.channelId in this.channels)
              ) {
                let chan = {};
                chan[item.channelId] = {
                  channel_id: item.channelId,
                  plain_id: item.plainId,
                  transport: item.transport,
                  channel_name: getDefaultName(item),
                  additional_option: [],
                };

                this.channels = { ...this.channels, ...chan };
              }

              channel_statuses[item.channelId] = item.state;
            });

            this.channel_statuses = { ...channel_statuses };
          }
        });
    },

    deleteChannel(id) {
      this.channels[id]["deleted"] = true;
    },
  },
});
