var MetaKeyComponent = {
    apikey: '',
    xsecret: '',

    balance: '',
    stat: '',

    setApikey: function(value) {
        this.apikey = value;
    },
    setXsecret: function(value) {
        this.xsecret = value;
    },

    getData: function() {
        var data = new FormData();
        data.append('init', 'getKey');
        data.append('csrf', csrf);
        m.request({
            method: 'POST',
            url: 'modules/dadata/request.php',
            data: data
        })
        .then(function(result) {
            MetaKeyComponent.setApikey(result['api_key']);
            MetaKeyComponent.setXsecret(result['x_secret']);
        })
    },

    saveKey: function() {
        var data = new FormData();
        data.append('csrf', csrf);
        data.append('api_key', MetaKeyComponent.apikey);
        data.append('x_secret', MetaKeyComponent.xsecret);
        m.request({
            method: 'POST',
            url: 'modules/dadata/request.php',
            data: data
        })
        .then(function(result) {
            if (MetaKeyComponent.apikey != '' && MetaKeyComponent.xsecret != '') {
                MetaKeyComponent.getBalance();
                MetaKeyComponent.getStat();
            }
        })
    },

    deleteKey: function(value) {
        var data = new FormData();
        data.append('csrf', csrf);
        data.append('init', 'deleteKey');
        data.append('value', value);
        m.request({
            method: 'POST',
            url: 'modules/dadata/request.php',
            data: data
        })
        .then(function(result) {
            if (result == 'done') {
                if (value == 'api_key') MetaKeyComponent.apikey = '';
                if (value == 'x_secret') MetaKeyComponent.xsecret = '';
            }
        })
    },

    getBalance: function() {
        var data = new FormData();
        data.append('csrf', csrf);
        data.append('calculation', 'balance');
        m.request({
            method: 'POST',
            url: 'modules/dadata/request.php',
            data: data
        })
        .then(function(result) {
            var res = JSON.parse(result);
            MetaKeyComponent.balance = res.balance;
        })
    },

    getStat: function() {
        var data = new FormData();
        data.append('csrf', csrf);
        data.append('calculation', 'stat');
        m.request({
            method: 'POST',
            url: 'modules/dadata/request.php',
            data: data
        })
        .then(function(result) {
            var res = JSON.parse(result);
            MetaKeyComponent.stat = res.services.suggestions;
        })
    },
}

function BalanceComponent() {
    return {
        oninit: function() {
            if (MetaKeyComponent.apikey != '' && MetaKeyComponent.xsecret != '') {
                MetaKeyComponent.getBalance();
                MetaKeyComponent.getStat();
            }
        },

        view: function() {
            return m('tr', m('td[colspan=2]', [
                m('div', {style:{'padding-top':'5px'}}, m('table', {width: '100%'}, [
                    m('tr', [
                        m('td', {style: {width: '50%'}, align:'right'}, m('span', 'Баланс:')),
                        m('td', {style: {width: '50%'}, align:'left'}, m('span', MetaKeyComponent.balance +' руб.'))
                    ]),
                    m('tr', [
                        m('td', {style: {width: '50%'}, align:'right'}, m('span', 'Статистика:')),
                        m('td', {style: {width: '50%'}, align:'left'}, m('span', MetaKeyComponent.stat +' запроса за сегодня'))
                    ])
                ]))
            ]));
        }
    }
}

function KeyComponent() {
    return {
        oninit: MetaKeyComponent.getData,
        
        view: function() {
            return m('table', [
                (MetaKeyComponent.apikey == '' || MetaKeyComponent.xsecret == '' 
                ? m('tr', [
                    m('td[colspan=2]', {style:{ 'padding-bottom': '20px', 'padding-left': '100px'}}, 
                        m('a[href=https://dadata.ru/?ref=80385#registration_popup][target=_blank]', 
                        m('span', 'Зарегистрироваться на Dadata.ru')
                    )),
                ]) 
                : m('tr', [
                    m('td[colspan=2]', {style:{ 'padding-bottom': '10px', 'padding-left': '100px'}}, 
                        m('a[href=https://dadata.ru/profile/#info][target=_blank]', 
                        m('span', 'Личный кабинет Dadata.ru')
                    )),
                ])),
                m('tr', [
                    m('td', {align:'right'}, m('span', 'API-ключ:')),
                    m('td', [
                        (MetaKeyComponent.apikey == '' ? m('input[type="text"]', {
                            class: 'form-control form-control-250',
                            onchange: function (e) { MetaKeyComponent.setApikey(e.target.value); MetaKeyComponent.saveKey(); },
                        }) : 
                        m('table', m('tr', [
                            m('td', {valign: 'bottom'}, m('span', MetaKeyComponent.apikey)),
                            m('td', {valign: 'top'}, m('a', {
                                onclick: () => MetaKeyComponent.deleteKey('api_key')
                            }, m('img', { src: 'images/b_drop.png', title: 'Удалить' })))
                        ])) )
                    ])
                ]),
                m('tr', [
                    m('td', {align:'right'}, m('span', 'Секретный ключ:')),
                    m('td', [
                        (MetaKeyComponent.xsecret == '' ? m('input[type="text"]', {
                            class: 'form-control form-control-250',
                            onchange: function (e) { MetaKeyComponent.setXsecret(e.target.value); MetaKeyComponent.saveKey(); },
                        }) : 
                        m('table', m('tr', [
                            m('td', {valign: 'bottom'}, m('span', MetaKeyComponent.xsecret)),
                            m('td', {valign: 'top'}, m('a', {
                                onclick: () => MetaKeyComponent.deleteKey('x_secret')
                            }, m('img', { src: 'images/b_drop.png', title: 'Удалить' })))
                        ])) )
                    ])
                ]),
                (MetaKeyComponent.apikey != '' && MetaKeyComponent.xsecret != '' ? 
                    m(BalanceComponent) 
                : '')
            ]);
        }
    }
}

m.mount(document.getElementById('key-component'), KeyComponent);
