import { components as localComponents } from "./formLine.js?v=3";
import { formBaseElement } from "./formBaseElement.js";
import useScopedStyleMixin from './useScopedStyleMixin.js';
import EditList from './entities/EditList/EditList.js?v=5';
import ListForm from './features/ListForm/ListForm.js?v=4';
import FormBlock from './features/ListForm/FormBlock/FormBlock.js';
import FormTab from './features/FormTab/FormTab.js';

localComponents['edit-list'] = EditList;
localComponents['edit-listform'] = ListForm; //Компонент - форма со списком
localComponents['edit-form-tab'] = FormTab; //Компонент - закладка
//Компонент - блок из нескольких строк формы
localComponents['edit-form-block'] = FormBlock;

//Компонент - форма
const Form = {
  name: 'edit-form',

  components: localComponents,

  mixins: [formBaseElement, useScopedStyleMixin],

  methods: {
    save(e) {
      e.preventDefault();
      this.store.save();
      return false;
    },
    generateStyles() {
      return `
        .${this.componentClass}__line${this.hash} {
          display: flex;
          align-items: center;
          justify-content: center;
          width: 100%;
          gap: 5px;
        }
      `
    },
  },

  data() {
    this.linesFromFields();
    this.blocksFromLines();
    if (this.element.saveButton === undefined) {
      this.element.saveButton = true;
    }
    return { componentClass: 'edit-form' }
  },

  computed: {
    formDataSource: function() {
      if (this.element.data) {
        return this.data[this.element.data] || {__loading: true};
      } else {
        return this.dataSource;
      }
    }
  },  

  template: /*html*/`
    <template v-if="showOn">
      <div 
        v-if="toggleLink" 
        class="editform-toggle"
      >
        <a href="#" v-on:click="toggle" :class="hidden ? '' : 'open'">{{$t(toggleLink)}}</a>
      </div>
      <form v-if="toggleShow" v-on:submit="save" class="editform-form" enctype="multipart/form-data">
        <input type="hidden" name="MAX_FILE_SIZE" value="10000000" />
        <h3 
          style="text-align: center;"
          v-if="element.header"
        >{{$t(element.header)}}</h3>
        <edit-form-block 
          v-for="block in element.formBlocks" 
          :dataSource="formDataSource" 
          :fieldsSource="formFieldsSource" 
          :element="block" 
        />
        <div 
          v-if="element.saveButton" 
          :class="componentClass + '__line' + hash"
        >
          <button type="submit" class="btn btn-default">
            {{ $t('editform_button_save') }}
          </button>
        </div>
      </form>
    </template>
  `
};

localComponents['edit-form'] = Form;

export default localComponents;
