import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import ArchiveButtonStyles from './ArchiveButtonStyles.js';

const ArchiveButton = {
  template: /*html*/`
    <button
      :class="componentClass + hash"
      @click="onClick"
    >
      <img 
        v-if="isFilterArchived"
        alt="восстановить" 
        title="Восстановить из архива" 
        src="images/b_restore.png" 
        border="0"
      >
      <img 
        v-else
        alt="в архив" 
        title="Отправить в архив" 
        src="images/b_archive.png" 
        border="0"
      >
      
    </button>
  `,
  props: {
    index: Number,
    isFilterArchived: Boolean
  },
  data() {
    return {
      componentClass: 'archive-button',
    }
  },
  mixins: [useScopedStyleMixin, ArchiveButtonStyles],
  name: 'archive-button',
  methods: {
    onClick(e) {
      e.preventDefault();
      this.$emit('click', this.index, e);
    },
  },
};

export default ArchiveButton