import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import TextStyles from './TextStyles.js';

const Text = {
  name: 'text',
  props: {
    storeFieldId: String,
    dataSource: Object,
  },
  data() {
    return {
      componentClass: 'text',
    }
  },
  computed: {
    text() {
      const data = this.dataSource || {};

      const toStr = (val) => {
        if (val == null) return '';

        // массивы (мультизначения и т.п.)
        if (Array.isArray(val)) {
          return val
            .map((item) => {
              // если внутри объекты — пробуем label/text, иначе просто в строку
              if (item && typeof item === 'object') {
                if ('label' in item) return String(item.label);
                if ('text' in item) return String(item.text);
                return Object.values(item).join(', ');
              }
              return String(item);
            })
            .join(', ');
        }

        // объекты (например {id: 1, label: 'Имя'})
        if (typeof val === 'object') {
          if ('label' in val) return String(val.label);
          if ('text' in val) return String(val.text);
          return Object.values(val).join(', ');
        }

        // число/булево и т.п.
        return String(val);
      };

      // базовый текст сообщения
      let text = toStr(data[this.storeFieldId]);

      // подстановка {{key}} значений
      for (let key in data) {
        const value = toStr(data[key]);
        const re = new RegExp('{{' + key + '}}', 'g');
        text = text.replace(re, value);
      }

      // всё, что осталось с {{...}} — заменяем на '--'
      text = text.replace(/{{[^}]+}}/g, '--');

      return text;
    }
  },
  mixins: [
    useScopedStyleMixin, 
    TextStyles
  ],
  template: /*html*/`
    <span
      :class="componentClass + hash"
    >
      {{ text }}
    <span/>
  `
};

export default Text;