const useScopedStyleMixin = {
  data() {
    return {
      hash: '_' + Math.random().toString(36).substr(2, 10) // Генерируем уникальный хэш
    };
  },
  beforeMount() {
    this.injectStyles();
  },
  mounted() {
    this.$nextTick(() => {
      this.injectStyles();
    });
  },
  methods: {
    injectStyles() {
      const styleId = `style-${this.hash}`;
      let styleTag = document.getElementById(styleId);

      if (!styleTag) {
        styleTag = document.createElement("style");
        styleTag.id = styleId;
        document.head.appendChild(styleTag);
      }

      if (typeof this.generateStyles === 'function') {
        styleTag.textContent = this.generateStyles();
      } else {
        console.warn(`[Mixin] generateStyles() is not defined in component with hash: ${this.hash}`);
      }
    }
  }
};

export default useScopedStyleMixin;