/** Добавление карточки */
export default{
  props: ['card'],

  data(){
    return {
      title: '',
      description: ''
    }
  },

  methods: {
    addCansel(){
      this.title = '';
      this.description = '';
      this.$emit('addCansel')
    },

    addSubmit(){
      this.$emit('addCardItem', {title: this.title,description: this.description})
    }
  },

  template: /*html*/`
    <form v-on:submit.prevent="addSubmit">
      <div style="text-align: left;margin-bottom: 5px;">
        <label style="width: 75px;">Title:</label>
        <input type="text" class="form-control form-control-100" v-model="title">
      </div>

      <div style="text-align: left;margin-bottom: 5px;">
        <label style="width: 75px;">Description:</label>
        <input type="text" class="form-control form-control-100" v-model="description">
      </div>

      <button style="margin-right: 10px;" type="submit">Save</button>
      <button v-on:click="addCansel">Cansel</button>
    </form>
  `
}
