<link rel="stylesheet" href="./stocks/style/editform.css?v=efv_7">

<div id="{$divExtensionId}" class="editform-container"></div>

<script type="module">
  import editFormApp from './stocks/app/editform/index.js?v=efv_6';
  import fields from './modules/{$extensionId}/settings/fields.js?v=efv_4';
  import composition from './modules/{$extensionId}/settings/composition.js?v=efv_4';
  import localeEn from './stocks/app/editform/locale/en.js';
  import localeRu from './stocks/app/editform/locale/ru.js';
  import moduleLocaleEn from './modules/{$extensionId}/settings/locale/en.js?v=efv_4';
  import moduleLocaleRu from './modules/{$extensionId}/settings/locale/ru.js?v=efv_4';
  import hashPathPlugin from './stocks/app/editform/components/hashPathPlugin.js?v=efv_3';

  const currentLocale = CB.globals.config.lang == "russian" ? "ru" : "en";

  const fullLocaleEn = Object.assign(localeEn, moduleLocaleEn);
  const fullLocaleRu = Object.assign(localeRu, moduleLocaleRu);

  const editformI18n = VueI18n.createI18n({
    locale: currentLocale,
    fallbackLocale: 'en',
    messages: {
      en: fullLocaleEn,
      ru: fullLocaleRu,
    },
  });

  const appSource = editFormApp({
    fields: fields,
    composition: composition,
    moduleId: "{$extensionId}",
    additional: {$additional},
    rootMode: true
  });

  const app = Vue.createApp(appSource);

  app.use(Pinia.createPinia());
  app.use(editformI18n);
  app.use(primevue.config.default);
  app.use(hashPathPlugin);

  app.mount('#{$divExtensionId}');
</script>
