$(document).ready(reportOnReady);

let urlSearchParams = new URLSearchParams(window.location.search);

function reportOnReady() {
  if(window.parent) {
    window.parent.postMessage(document.getElementsByTagName("html")[0].scrollHeight, "*");
  }

  init_report_script();
  additionalReportOptions();

  window.addEventListener("beforeprint", (event) => {
    prepareReportForPrint()
  });
  window.addEventListener("afterprint", (event) => {
    returnReportAfterPrint()
  });

  setTimeout(() => {
    $('select:not(.select2-plugin)[id^="P"][datatype="link_field"]')
      .each((_, item) => $(item).chosen({ search_contains: true }));
  }, 200);

  if (window.screen.width <= 1200) {
    centerGraphScrolls()
  }

  $("select.choosen").chosen({ search_contains: true });

  // фиксируем скролл таблицы для отчетов по внешней ссылке
  if (urlSearchParams.get('id') === null) {
    fixedTable();
  }
}

function prepareReportForPrint() {
  let element = document.querySelector('.repconview__layout');
  let no_print_graphs = document.querySelectorAll('.repconview__layout > .no_print')
  no_print_graphs.forEach( (item) => {
    item.classList.remove('no_print')
    item.classList.add('return_no_print')
  })
  element.classList.add('report-print')
}
function returnReportAfterPrint() {
  let element = document.querySelector('.repconview__layout');
  let no_print_graphs = document.querySelectorAll('.repconview__layout > .return_no_print')
  no_print_graphs.forEach( (item) => {
    item.classList.remove('return_no_print')
  })
  element.classList.remove('report-print')
}


function showAAUpdatedLines() {
  let aa_table = JSON.parse($.cookie('aa_table') || '{}');

  if (Object.keys(aa_table).length != 0 && aa_table.table_id.length > 0) {
    $('[table_id='+(aa_table.table_id)+']').find('tr').each((i, el) => {
      if (aa_table.sels.includes(parseInt($(el).attr('line_id')))) {
        $(el).css('background-color', '#fff6ad');
        setTimeout(() => {
          $(el).css('background-color', '');
        }, 2000);
      }
    });
  }

  $.removeCookie('aa_table');
}

// Изображение при переключении периодов
function add_img_update(element) {
  element.each((i, el) => {
    if ($(el).hasClass('repconview__caption-params-info-updated')) {
      // $(el).attr('src', 'images/report-parameters_update.svg');
      let parentBlock = $(el).closest('.repconview__indicator_one_third'); // Для блочных показателей
      let parentTable = $(el).closest('.table_div_container'); // Для табличных показателей
      if (parentBlock) {
        parentBlock.find('.repconview__indicator_one_third__body a').addClass('repconview__indicator-value_updated');
        parentBlock.find('.repconview__indicator_one_third__body span').addClass('repconview__indicator-value_updated');
      }
      if (parentTable) {
        parentTable.find('.repconview__table_table td span').addClass('repconview__indicator-value_updated');
      }
    };
  });
};

function remove_indicator_update(element) {
  let parentBlock = element.closest('.repconview__indicator_one_third'); // Для блочных показателей
  let parentTable = element.closest('.table_div_container'); // Для табличных показателей

  if (parentBlock) {
    parentBlock.find('.repconview__indicator_one_third__body a').addClass('repconview__indicator-value_default');
    parentBlock.find('.repconview__indicator_one_third__body span').addClass('repconview__indicator-value_default');
  }
  if (parentTable) {
    parentTable.find('.repconview__table_table td span').addClass('repconview__indicator-value_default');
  }
}

function remove_class_update(element) {
  element.each(function(i, el) {
    if($(window).scrollTop() + $(window).height() >= $(el).offset().top && $(el).hasClass('repconview__caption-params-info-updated')) {
      setTimeout(() => {
        $(el).removeClass('repconview__caption-params-info-updated');
        // $(el).attr('src', 'images/report-parameters.svg');
        remove_indicator_update($(el));
      }, 750);
    }
  });
};

function copyToShare(link){
  var tmp = $("<textarea id='share' style='position: absolute; top:-1000px'>");
  $("body").append(tmp);
  $('#share').val(link).select();
  document.execCommand("copy");
  displayNotification(lang['Link_copied'], 1);
};

function remove_class_update_for_scroll(element) {
  $(window).scroll(function() {
    element.each((i, el) => {
      if($(window).scrollTop() + $(window).height() >= $(el).offset().top && $(el).hasClass('repconview__caption-params-info-updated')) {
        // setTimeout(() => {
        $(el).removeClass('repconview__caption-params-info-updated');
        // $(el).attr('src', 'images/report-parameters.svg');
        remove_indicator_update($(el));
        // }, 1000);
      }
    });
  });
}

function toggleCollapseEntity(report_id, entity_id){
  let collapsed_items = JSON.parse($.cookie('cb_reports_collapsed') ?? '{}');

  let collapsed_entities_set = new Set(collapsed_items[report_id] ? (collapsed_items[report_id]['entities'] ?? []) : []);

  if(!!$('#checkbox_' + entity_id).prop('checked')){
    collapsed_entities_set.delete(entity_id);
  }
  else {
    collapsed_entities_set.add(entity_id);
  }

  collapsed_items[report_id] = {
    timestamp: Math.round((Date.now() / 1000)),
    entities: Array.from(collapsed_entities_set),
  };

  $.cookie('cb_reports_collapsed', JSON.stringify(collapsed_items),  { expires: 365, path: '/' });
}

async function init_report_script() {
  document.addEventListener('visibilitychange', function(e) {
    if(document.hidden){
      $('#jqContextMenu').hide();
    }
  });

  $('.date_param').datepicker({
    showOn: "button",
    dateFormat: lang.date_js_format,
    showAlways: true,
    buttonImage: 'images/calbtn.png',
    buttonImageOnly: true,
    buttonText: 'Calendar',
    showAnim: (('\v' == 'v') ? '' : 'show')  // в ie не включаем анимацию, тормозит
  }).attr('placeholder', lang.date_placeholder);

  showAAUpdatedLines();

  $('.input_element').each((i, el) => {
    $(el).find('select').on('change', (e) => {
      $(e.target).parents('.input_element').attr('changed', 'true');
    });

    $(el).find('input').on('change', (e) => {
      $(e.target).parents('.input_element').attr('changed', 'true');

      if ($(e.target).attr('datatype') == 'period') {
        $(e.target).parents('.input_element').attr('other_period', 'true');
      }
    });

    if ($('.input_element').length > 0) {
      if ($(el).attr('datatype') == 'period') {
        $(el).find('input').on('change', () => updateReport());
      } else {
        $(el).find('select').on('change', () => updateReport());
      }
    } else {
      if ($(el).attr('datatype') != 'period' && $('body').width() <= 480) {
        $(el).find('select').on('change', () => updateReport());
      }
    }
  });

  $('body').click(function (e) {
    if($(e.target).parents('.flexMenu-viewMore').length < 1 && !$(e.target).hasClass('flexMenu-viewMore')){
      $('.flexMenu-viewMore').removeClass('dropMenu__button--active');
      $('.flexMenu-viewMore').find('.flexMenu-popup').css('display', 'none');
    }
  });

  $('.repconview_params').find('select').each(_ => {
    init_chosen();
  });

  for(let item of document.querySelectorAll("input[type=checkbox][class=caption_checkbox]")) {
    item.onchange = function(){
      this.parentNode.classList.toggle("checked", this.checked);
    }
  }

  $('.repconview__layout').css('opacity','1');
  $('.loadi').remove();
  //$('.preloader__block').remove();
  //$('.preloader__block.type-2').remove();


  add_img_update($('.repconview__caption-params-info'));
  remove_class_update($('.repconview__caption-params-info'));
  remove_class_update_for_scroll($('.repconview__caption-params-info'));

  window.updateReport = updateReport;

}

function dropFlexMenu(el) {
  if($(el).find('.flexMenu-popup').css('display') == 'none'){
    $(el).addClass('dropMenu__button--active');
    $(el).find('.flexMenu-popup').css('display', 'block');
  }
  else {
    $(el).removeClass('dropMenu__button--active');
    $(el).find('.flexMenu-popup').css('display', 'none');
  }
}

function getChangedParams() {
  let params = [];
  let is_other_period = false;
  $('.input_element').each((i, el) => {
    if($(el).attr('changed') == 'true'){
      params.push($(el).attr('param_name'));
    }
    if($(el).attr('other_period') == 'true'){
      is_other_period = true;
    }
  });

  return {
    params: params.join('|'),
    is_other_period
  };
}

function generateParamsStr(use_changed_params = true) {
  let params_request_str = "";
  let changed_params = getChangedParams();

  let search_url = '';
  let search_block_values = '';
  let search_type = '';
  if (typeof window['search_block_values'] !== 'undefined') {
    for (let item in window['search_block_values']) {
      let value = window['search_block_values'][item];
      search_block_values = `&${item}=${value}`;
    }
    for (let item in window['search_type']) {
      let value = window['search_type'][item];
      search_type = `&${item}=${value}`;
    }
    search_url = `${search_block_values}${search_type}`;
  }

  $('.input_element').each(function (i, el) {
    let param_name = $(el).attr('param_name');
    let param_type = $(el).attr('datatype');

    if(param_type == 'period'){
      params_request_str += (param_name + '=' + $('#' + param_name + '_low').val() + '|' + $('#' + param_name + '_high').val() + '&');
    } else {
      params_request_str += (param_name + '=' + $('#' + param_name).val() + '&');
    }
  });

  params_request_str = params_request_str.slice(0, -1) + (use_changed_params ? '&changed_params=' + changed_params.params + (changed_params.is_other_period ? '&other_period=true' : '') : '');

  return params_request_str + (search_url == '' ? '' : `${search_url}`);
}

function exportExcel() {
  let params_request_str = generateParamsStr();
  let url = location.href + '&getexcel=getexcel&' + params_request_str;

  window.open(url, '_blank');
}

function exportPDF_old() {
    let params_request_str = generateParamsStr();
    let url = location.href + '&getpdf=getpdf&' + params_request_str;
    window.open(url, '_blank');
}

function findReplaceGraphs(id_array) {
  id_array.forEach( (id) => {
    let main_report = document.querySelector('.repconview__layout:not(.clone)')
    let clone_report = document.querySelector('.repconview__layout.clone')

    let finded_new_element = main_report.querySelector(`#${id}`).closest('.repconview__layout-graph')
    let finded_cloned_element = clone_report.querySelector(`#${id}`).closest('.repconview__layout-graph')

    element_replace(finded_new_element, finded_cloned_element)
  })
}

function element_replace(new_el, old_el) {
  old_el.parentNode.replaceChild(new_el, old_el)
}

function prepareToExportPDF() {
    let element = document.querySelector('.repconview__layout');

    let hundred_graphs = document.querySelectorAll('.repconview__layout:not(.clone) .repconview__layout-graph.repconview__block-hundred')
    let saved_ids = []
    hundred_graphs.forEach( (graph) => {
      let id = graph.querySelector('[id]').id
      saved_ids.push(id)
    })

    let clone_report = element.cloneNode(true)


    clone_report.classList.add('clone')
    clone_report.classList.add('export-pdf')

    clone_report_wrap = document.createElement('div')
    clone_report_wrap.style.display = 'none';

    clone_report_wrap.append(clone_report)
    document.body.append(clone_report_wrap)


    updateReport(true, false, saved_ids)

}
function exportPDF() {
    let element = document.querySelector('.repconview__layout.clone');
    let remove_blocks = document.querySelectorAll('.repconview__layout.clone > :not(.repconview__layout-graph)')
    remove_blocks.forEach( (item) => {
      item.remove()
    })
    let blocks = document.querySelectorAll('.repconview__layout.clone > div')
    blocks.forEach( (item) => {
      if (item.innerHTML.includes('Нет данных')) {
        item.remove()
      }
    })

    var options = {
      filename: `${document.title}.pdf`,
      margin: 20,
      pagebreak: {
        mode: ['css', 'legacy'],
        avoid: ['.repconview__layout-graph'],
      },
      image: { type: 'png', quality: 1 },
      jsPDF: {
        //unit: 'in',
        //format: 'letter',
        orientation: 'landscape'
      },
      html2canvas: {
          onclone: (element) => {
          },
          letterRendering: true
      }
    }

    var pdf = html2pdf().set(options).from(element).toPdf().get('pdf').then(function (pdf) {
    }).save().then(function() {
      document.querySelector('.report').classList.remove('clone-report')
    });

}


/**
 * Запросить с сервера и обновить отчет.
 * Фактически заменив innerHTML элемента rapps-root-report-view.
 *
 * @param {boolean} always      Принудительно обновить
 * @param {boolean} first_boot  Первая загрузка отчета
 * @returns {void}
 */
async function updateReport(always = false, first_boot = false, saved_ids = false) {
  /**
   * Получить параметры сортировки.
   *
   * @returns {String}
   */
  function getSortOptions() {
    let sort_options = [];
    const sort_settings = JSON.parse(sessionStorage.getItem('sort_settings') || '{}');

    if (typeof sort_settings === 'object') {
      Object.keys(sort_settings).forEach(index => {
        let column_id = sort_settings[index]['column_id'] || '';
        let sorting_direction = sort_settings[index]['sorting_direction'] || 'asc';

        if (column_id != '') {
          sort_options.push({
            'block_id':  index,     // Идентификатор блока
            'column_id': column_id, // Идентификатор столбца
            'sorting_direction': sorting_direction // Направление сортировки
          });
        }
      });
    }

    return sort_options.length > 0
      ? ('&sort=' + encodeURIComponent(JSON.stringify(sort_options)))
      : '';
  }

  if (
    !always &&
    $("#btn-expansion-options").hasClass('repconview__btn-expansion-options_open')
  ) {
    return;
  }

  $('#jqContextMenu').hide();
  if($('body').width() > 990 && CB.globals.config.is_mobile != '1'){
    $('.repconview__layout')[0].classList.add('temp-hide')
    $('.repconview__layout').prepend(create_preloader_block());
  }
  //showPreloader();

  let params_request_str = generateParamsStr();
  let url = new URL(location.href);

  const sort_options = getSortOptions();
  const new_url = (
    url.pathname.indexOf('report_external.php') !== -1
  ) ? (
    url.origin + url.pathname + '?hash=' + urlSearchParams.get('hash') + '&' + generateParamsStr(false)
  ) : (
    url.origin + url.pathname + '?id=' + urlSearchParams.get('id') + '&' + generateParamsStr(false)
  );

  if (!first_boot) window.history.pushState(null, null, (new_url + sort_options));

  const url_string = first_boot
    ? `${url.origin}${url.pathname}${url.search}&getdata=getdata`
    : `${location.href}&getdata=getdata&${params_request_str}${sort_options}`;

  if (params_request_str.length > 0) {
    $.ajax({
      url: url_string,
      success: function(layout) {
        $('#rapps-root-report-view').html(layout);
        eval($('#rapps-root-report-view').find("script").text()); // запускаем скрипты

        $('.repconview__layout').prepend(`
          <div
            class="loadi"
            style="background: white;height:1000px;transition: all 0.2s linear 0s;"
          ></div>
        `);
        $('.repconview__layout').css({'transition': 'all 0.5s linear 0s', 'opacity':'0'});
        reportOnReady();

        startVueApplications();

        setTimeout(() => {
          init_report_script();

          const select2_plugin = $('.select2-plugin');
          if (select2_plugin.length > 0) {
            select2_plugin.select2();
          }

          if (saved_ids) {
            findReplaceGraphs(saved_ids)
            exportPDF()
          }

          if ($('.repconview__layout').length > 0) {
            $('.repconview__layout')[0].classList.remove('temp-hide');
          }
          //$('.preloader__block.type-2').remove();
        }, 0);

        fixedTable();
      }
    });
  }
}

function fixedTable() {
  if ($('.repconview__table_table').length > 0) {
    $('.repconview__table_table').fixedTable();
  }
}

function showPreloader() {
    let report = document.querySelector('.repconview__layout > div')
    if (report.innerHTML == false) {
        create_report_preloader_block().insertBefore($('.repconview__layout'))
    } else {
        $('.repconview__layout').prepend(create_report_preloader_block());
    }
}

function startVueApplications() {
  $('.repconview__layout div[id^=SRC]').each((_, item) => {
    let block_name = item.id;

    if ( // блок поиска
      typeof window['search_block_values'] !== 'undefined' &&
      typeof window['report_search_blocks'] !== 'undefined' &&
      typeof window['report_search_blocks'][block_name] !== 'undefined'
    ) {
      CB.report.createSearchBlock(window['report_search_blocks'][block_name]);
    }

    // Очищаю от предыдущих событий
    CB.pubsub.unsubscribe('report-constructor/initialization');
    // Подписаться на события инициализации vue приложений
    CB.pubsub.subscribe('report-constructor/initialization', function(payload) {
      switch (payload.block) {
        case 'kanban':
          CB.report.createKanbanBlock(payload.ident, payload.data);
          break;

        default: break;
      }
    });
  });

  setTimeout(_ => fixedTable(), 1000);
}

/**
 * Переключить квартал.
 * @param {*} el Элемент
 * @param {*} date дата
 * @param {*} direction направление
 */
function changeQuarter(el, date, direction) {
  let name_param = $(el).attr('id').split('_')[0];
  let _date = moment(date);
  _date = direction == 'up' ? _date.add(1, 'days') : _date.subtract(1, 'days');

  let date_start = '';
  let date_end = '';

  if (direction == 'up') { // переключение вперед
    date_start = _date.add(1, 'days').startOf('month');
    date_end = moment(date_start).add(85, 'days').endOf('month');
  } else if (direction == 'down') { // переключение назад
    date_end = _date.subtract(1, 'days').endOf('month');
    date_start = moment(date_end).subtract(85, 'days').startOf('month');
  } else {
    return;
  }

  date_start = moment(date_start).format("DD.MM.YYYY");
  date_end   = moment(date_end).format("DD.MM.YYYY");

  $('#' + name_param + '_low').parents('.input_element').attr('changed', 'true');
  $('#' + name_param + '_low').val(date_start);
  $('#' + name_param + '_high').val(date_end);

  // Если пользователь нажал на иконку, раскрыть все параметры,
  // то перезагрузка происходит, только по нажатию кнопки "Обновить",
  // как при изменении первого параметра, так и остальных.
  if ($("#btn-expansion-options").hasClass('repconview__btn-expansion-options_open')) {
    return;
  } else {
    updateReport();
  }
}

function changePeriod(el, period, is_increment) {
  let parameter_name = $(el).attr('data-param-name') || '';     // название параметра
  let count_periods  = Number($(el).attr('data-count-periods') || 1); // кол-во периодов
  let format = lang.short_name == 'us' || lang.short_name == 'en' ? 'DD/MM/YYYY' : 'DD.MM.YYYY';
  let add_param = is_increment ? count_periods : (-1 * count_periods);

  let low_param_value  = $(`#${parameter_name}_low`).val();   // нижняя дата
  let high_param_value = $(`#${parameter_name}_high`).val();  // верхняя дата
  let new_low_value    = '';
  let new_high_value   = '';

  new_low_value = moment(low_param_value, 'DD.MM.YYYY').add(add_param, period).format(format);
  if (period == 'month') {
    new_high_value = moment(high_param_value, 'DD.MM.YYYY').add(add_param, period).endOf('month').format(format);
  } else {
    new_high_value = moment(high_param_value, 'DD.MM.YYYY').add(add_param, period).format(format);
  }

  if (new_low_value == low_param_value || new_high_value == high_param_value) {
    // если переключаемся на февраль с марта, то минус 13 дней от периода
    let day_count = (moment(low_param_value, 'DD.MM.YYYY').format('MM') == '03' && !is_increment) ? 13 : 15;
    let temp = moment(low_param_value, 'DD.MM.YYYY').add(add_param * day_count + 1, 'day');
    if (temp.date() <= 15) {
      new_low_value  = temp.startOf('month').format(format);
      new_high_value = temp.date(15).format(format);
    } else {
      new_low_value  = temp.date(16).format(format);
      new_high_value = temp.endOf('month').format(format);
    }
  }

  $(`#${parameter_name}_low`).parents('.input_element').attr('changed', 'true');
  $(`#${parameter_name}_low`).val(new_low_value);
  $(`#${parameter_name}_high`).val(new_high_value);

  // Если пользователь нажал на иконку, раскрыть все параметры,
  // то перезагрузка происходит, только по нажатию кнопки "Обновить",
  // как при изменении первого параметра, так и остальных.
  if ($("#btn-expansion-options").hasClass('repconview__btn-expansion-options_open')) {
    return;
  } else {
    updateReport();
  }
}

function changeProgressBarValue(el, _value, animate = false) {
  let value = parseFloat(animate ? el.attr('progress-value') : _value);
  el.find('.progress_bar__value').text(value.toFixed(2).replace('.', ','));
  el.find('#left_chunk').css('transform', 'rotate('+ (3.6 * value) +'deg)');

  if(value >= 50) {
    el.find('.progress_bar').css('clip', 'rect(auto, auto, auto, auto)');
    el.find('#right_chunk').css({
      'display': 'block',
      'transform': 'rotate(180deg)',
    });
  }

  if(animate){
    el.attr('progress-value', ((value + 1) > _value && value < _value ? _value : (value + 1)));
    if(value != _value){
      setTimeout(() => {
        changeProgressBarValue(el, _value, true);
      }, 25);
    }
  }
}

/**
 * Функция инициализирует скрытие/показ параметров в отчетах
 *
 * @returns {void}
 */
function additionalReportOptions() {
  let topOption = $('.report__title .input_element');
  let additionalOptions = $('.repconview_params');

  if (topOption.length === 1 && additionalOptions.length === 1) {
    let btnExpansionOptions = `<span id='btn-expansion-options' class="repconview__btn-expansion-options" onclick="btnShowOptions(this)"></span>`;
    topOption[0].insertAdjacentHTML('beforeend', btnExpansionOptions);

    let status = false;
    status = artificeWithStorage();

    let selectOptions = $('.repconview_params .input_element .repconview__param-inputs select[id^=P]');
    for (let i = 0; selectOptions.length > i; i++) {
      if (selectOptions[i].value != '') {
        status = true;
        break;
      }
    }

    showAdditionalOptions(status);
  }
}

/**
 * @param status
 * @returns visibility = show/hide в localStorage['report_expansion']
 */
function btnShowOptions(btn) {
  let localPeriodData = JSON.parse(localStorage.getItem('report_expansion'));

  if ($(btn).is('.repconview__btn-expansion-options_open')) {
    // hide
    localPeriodData['visibility'] = 'hide';
  } else {
    // open
    localPeriodData['visibility'] = 'open';
  }

  localStorage.setItem('report_expansion', JSON.stringify(localPeriodData));
  showAdditionalOptions(true);
}

/**
 * Вся функция связана на localStorage и параметров в URL
 * Возвращает true/false
 */
function artificeWithStorage() {
  let urlData = window.location.search;

  // Если переключали период
  if (urlData.search('P1') > 0) {
    let periodList = JSON.parse(localStorage.getItem('report_expansion'));
    if (periodList === null) {
      writeInStorage();
      periodList = JSON.parse(localStorage.getItem('report_expansion'));
    }

    // достаем id отчета из url
    let reportId = new URL(window.location.href).searchParams.get('id');
    let urlParams = window.location.search;

    for (let key in periodList[reportId]) {
      // вернет P__
      let attrP = key.split('_', 1);
      let sequence = key.split('_', 2)[1];

      // Позволяет достать данные конкретного периода по url
      let urlPeriod = urlParams.split(attrP + '=', 2)[1].split("&", 1)[0];

      let num = (sequence.includes('low')) ? 0 : 1;

      if (periodList[reportId][key] !== urlPeriod.split('|')[num]) {
        return true;
      }
    }
  } else {
    // При первом открытии отчета записываем значения в localStorage
    writeInStorage();
  }
}

/**
 * записывает значения полей даты
 * записывает в localStorage ключом report_expansion
 */
function writeInStorage() {
  let dateInputs = $('.repconview_params .input_element[datatype="period"] .date_param[datatype="period"]');
  let dataInputsList = {};

  dateInputs.each(function(i, elem) {
    let idInput = elem.getAttribute('id');
    dataInputsList[idInput] = elem.value;
  })

  let reportId = new URL(window.location.href).searchParams.get('id');
  let currentPeriodList = {};
  currentPeriodList[reportId] = dataInputsList;

  localStorage.removeItem('report_expansion');
  localStorage.setItem('report_expansion', JSON.stringify(currentPeriodList));
}

function showAdditionalOptions(status) {
  let localPeriodData = JSON.parse(localStorage.getItem('report_expansion'));
  let localVisibility = localPeriodData['visibility'];

  // в приоритете статус open/hide по кнопке
  if (localVisibility !== undefined && localVisibility !== null) {
    let btnExpansOptions = $('.repconview__btn-expansion-options');
    let additionalOptions = $('.repconview_params');

    if (localVisibility === 'open') {
      if (!$(btnExpansOptions[0]).is('.repconview__btn-expansion-options_open')) {
        btnExpansOptions[0].classList.add('repconview__btn-expansion-options_open');
      }
      if ($(additionalOptions[0]).is('.repconview_params_close')) {
        additionalOptions[0].classList.remove('repconview_params_close');
      }
    } else if (localVisibility === 'hide') {
      if ($(btnExpansOptions[0]).is('.repconview__btn-expansion-options_open')) {
        btnExpansOptions[0].classList.remove('repconview__btn-expansion-options_open');
      }
      if (!$(additionalOptions[0]).is('.repconview_params_close')) {
        additionalOptions[0].classList.add('repconview_params_close');
      }
    }
  } else if (status) {
    let btnExpansOptions = $('.repconview__btn-expansion-options');
    btnExpansOptions[0].classList.toggle('repconview__btn-expansion-options_open');

    let additionalOptions = $('.repconview_params');
    additionalOptions[0].classList.toggle('repconview_params_close');
  }
}

/**
 * Сформировть сортировку в блоке.
 *
 * @param {String} block_id             Идентификатор блока
 * @param {String} column_id            Идентификатор столбца
 * @param {String} sorting_direction    Направление сортировки
 * @returns {void}
 */
function buildSortingInBlock(block_id, column_id, sorting_direction) {
  /**
   * Получить настройки сортировки.
   *
   * @returns {Object}
   */
  function getSortSettings() {
    const settings = sessionStorage.getItem('sort_settings');

    if (settings == null) {
      saveSortSettings({});
      return getSortSettings();
    }

    return JSON.parse(settings);
  }

  /**
   * Сохранить  настройки сортировки.
   *
   * @param {Object} settings
   * @returns {void}
   */
  function saveSortSettings(settings) {
    sessionStorage.setItem('sort_settings', JSON.stringify(settings));
  }

  const sort_settings = getSortSettings();

  if ( // по данному блоку нет настроек сортировки
    typeof sort_settings[block_id] === 'undefined'
  ) {
    sort_settings[block_id] = { 'column_id': '', 'sorting_direction': '' };
  }

  sort_settings[block_id]['column_id'] = column_id;
  switch (sorting_direction) {
    case '':
      sort_settings[block_id]['sorting_direction'] = 'asc';
      break;

    case 'asc':
      sort_settings[block_id]['sorting_direction'] = 'desc';
      break;

    case 'desc':
      delete sort_settings[block_id];
      break;
  }

  saveSortSettings(sort_settings);
  updateReport(true);
}

function centerGraphScrolls() {
  let blocks = document.querySelectorAll('.repconview__layout-graph-container')
  blocks.forEach( (item) => {
    item.scrollLeft = (item.scrollWidth - item.clientWidth) / 2
  })
}
/**
 * Создает дебаунсированную версию функции, которая будет вызываться 
 * только после того, как прошло указанное время (wait) с момента последнего вызова.
 *
 * @param {Function} func - Функция, которую нужно дебаунсировать.
 * @param {number} wait - Время в миллисекундах, в течение которого функция 
 *                        не будет вызываться повторно.
 * @returns {Function} Возвращает новую функцию, которая будет вызывать 
 *                     переданную функцию только после того, как 
 *                     пройдет указанное время с момента последнего вызова.
 */
const debounce = (func, wait) => {
  let timeout;

  return (...args) => {
    const later = () => {
      clearTimeout(timeout);
      func(...args);
    };

    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
  };
};

/**
 * Состояние, аналогичное React, для отслеживания и обновления значения.
 * 
 * @param {any} initialValue - Начальное значение состояния.
 * @returns {Array} Массив, содержащий:
 *  - Функция для получения текущего значения состояния.
 *  - Функция для обновления состояния.
 *  - Функция для подписки на изменение состояния.
 */
const useState = (initialValue) => {
  let value = initialValue; // Храним текущее состояние (может быть объектом)
  const listeners = new Set();

  // Функция для обновления состояния
  const setState = (newValue) => {
    if (typeof newValue === 'function')
      value = newValue(value); 
    // Если новое значение — объект, создаем новый объект для предотвращения мутации
    else if (typeof newValue === 'object' && newValue !== null) {
      value = { ...newValue }; // Создаем новый объект (глубокое копирование можно сделать для сложных объектов)
    } else {
      value = newValue;
    }
    
    listeners.forEach((listener) => listener(value));
  }

  const onStateChange = (listener) => {
    listeners.add(listener);
    return () => listeners.delete(listener); // Возвращаем функцию для отмены подписки
  };

  // Возвращаем массив с функцией для получения значения и функцией для его обновления
  return [() => value, setState, onStateChange]; 
}

// Изолированный функционал настроек отображаемых столбцов
(() => {

  /**
   * Получает все таблицы на странице, извлекает информацию о каждой таблице.
   * 
   * @returns {Array<Object>} Возвращает массив объектов, каждый из которых содержит информацию о таблице:
   *  - `tableName` (string): Имя таблицы, взятое из первого элемента <label> внутри контейнера таблицы.
   *  - `tableIndex` (number): Индекс таблицы в контейнере.
   *  - `tableHeadersNames` (Array<string>): Массив имен заголовков столбцов таблицы.
   *  - `tableBlock` (Element): DOM элемент контейнера таблицы.
   */
  const getTables = () => {
    const tableContainers = document.querySelectorAll('.table_div_container ');

    const getTable = (tableBlock, index) => {
      const tableName = tableBlock.querySelector('label')?.innerText;
      const tableHeaders = tableBlock.querySelectorAll('table > thead > tr > th');
      const tableHeadersNames = [ ...tableHeaders ].map((tableHeader) => 
        tableHeader.innerText.replace(/\s+/g, ' ').trim()
      );

      return { tableName, tableIndex: index, tableHeadersNames, tableBlock };
    };

    return [ ...tableContainers ].map(getTable);
  }
  /**
   * Получает идентификатор отчета из параметров URL.
   * 
   * Извлекает значение параметра `id` из строки запроса текущего URL.
   * 
   * @returns {string|null} Возвращает значение параметра `id` из URL или `null`, если параметр не найден.
   */
  const getReportId = () => {
    const urlParams = new URLSearchParams(window.location.search);
    const id = urlParams.get('id');

    return id;
  }

  /**
   * Сохраняет фильтр для указанной таблицы в локальное хранилище.
   * 
   * Сохраняет состояние фильтра (видимость столбцов) для конкретной таблицы
   * в локальном хранилище с использованием ключа, основанного на `reportId`, имени таблицы и индексе.
   * 
   * @param {Object} params - Параметры функции.
   * @param {string} params.tableName - Имя таблицы для которой сохраняется фильтр.
   * @param {number} params.tableIndex - Индекс таблицы.
   * @param {Object} params.filter - Объект фильтра, представляющий состояние видимости столбцов.
   * @returns {boolean} Возвращает `true`, если фильтр был успешно сохранен, и `false`, если произошла ошибка.
   */
  const setSavedFilter = ({ tableName, tableIndex, filter }) => {
    try {
      // Получаем reportId
      const reportId = getReportId();

      localStorage.setItem(
        `report?id=${reportId}&name=${tableName}_${tableIndex}`,
        JSON.stringify(filter)
      );
      return true;
    } catch (error) {
      return false;
    }
  }

  /**
   * Получает сохраненный фильтр из локального хранилища для указанной таблицы.
   * 
   * @param {Object} params - Объект параметров.
   * @param {string} params.tableName - Имя таблицы для которой нужно получить фильтр.
   * @param {number} params.tableIndex - Индекс таблицы.
   * @returns {Object} Возвращает объект фильтра, если он найден в локальном хранилище, или пустой объект, если фильтр не найден.
   */
  const getSavedFilter = ({ tableName, tableIndex }) => {
    try {
      // Получаем reportId
      const reportId = getReportId();
      const filterJson = localStorage.getItem(`report?id=${reportId}&name=${tableName}_${tableIndex}`);
      if (!filterJson) return {};
      
      return JSON.parse(filterJson);
    } catch (error) {
      return {};
    }
  }

  /**
   * Создает объект фильтра с значениями `true` для каждого заголовка таблицы.
   * 
   * @param {Array<string>} tableHeadersNames - Массив имен заголовков таблицы.
   * @returns {Object} Возвращает объект, где для каждого заголовка таблицы установлено значение `true`.
   */
  const getDefaultFilter = (tableHeadersNames) => 
    tableHeadersNames.reduce((result, header) => {
      result[header] = true;
      return result;
    }, {});

  /**
   * Получает начальный фильтр для таблицы, объединяя значения по умолчанию и сохраненные фильтры.
   * 
   * @param {Object} params - Объект параметров.
   * @param {string} params.tableName - Имя таблицы для которой нужно получить фильтр.
   * @param {number} params.tableIndex - Индекс таблицы.
   * @param {Array<string>} params.tableHeadersNames - Массив имен заголовков таблицы.
   * @returns {Object} Возвращает объект начального фильтра, объединяя сохраненный фильтр и значения по умолчанию.
   */
  const getInitialFilter = ({ tableName, tableIndex, tableHeadersNames }) => {
    // Получаем значение фильтра из локального хранилища
    const savedFilter = getSavedFilter({ tableName, tableIndex });
    // Получаем значение фильтра на основе заголовков таблицы
    const defaultFilter = getDefaultFilter(tableHeadersNames);
    const initialFilter = { ...defaultFilter, ...savedFilter };

    return initialFilter;
  }

  /**
   * Показывает все дочерние элементы таблицы, сбрасывая их стиль `display` на значение по умолчанию.
   * 
   * @param {Object} params - Объект параметров.
   * @param {HTMLElement} params.tableBlock - Блок, содержащий таблицу, дочерние элементы которой будут показаны.
   */
  const showTable = ({ tableBlock }) => {
    const tableChildrens = tableBlock.children;
    [ ...tableChildrens ].forEach(child => child.style.display = '');
  }
  /**
   * Скрывает все дочерние элементы таблицы, устанавливая их стиль `display` в 'none'.
   * 
   * @param {Object} params - Объект параметров.
   * @param {HTMLElement} params.tableBlock - Блок, содержащий таблицу, дочерние элементы которой будут скрыты.
   */
  const hideTable = ({ tableBlock }) => {
    const tableChildrens = tableBlock.children;
    [ ...tableChildrens ].forEach(child => child.style.display = 'none');
  }

  /**
   * Создает информацию о скрытой таблице и отображает её пользователю.
   * Включает блок с сообщением о скрытой таблице и кнопку для восстановления отображения.
   * После нажатия кнопки, таблица снова станет видимой и фильтр будет сброшен.
   *
   * @param {Object} params - Объект параметров.
   * @param {HTMLElement} params.tableBlock - Блок, содержащий таблицу, для которой нужно отобразить информацию о скрытии.
   * @param {string} params.tableName - Имя таблицы, отображаемое в сообщении о скрытии.
   * @param {number} params.tableIndex - Индекс таблицы, используется для сохранения состояния фильтра.
   * @param {Function} params.setFilter - Функция для обновления фильтра, устанавливает видимость всех столбцов на true.
   *
   * @returns {HTMLElement} Возвращает блок с информацией о скрытой таблице.
   */
  const createHiddenTableInfo = ({ 
    tableBlock, 
    tableName, 
    tableIndex, 
    setFilter 
  }) => {
    const hiddenBlock = document.createElement('section');
    hiddenBlock.classList.add('table-hidden');
    const hiddenInfo = document.createElement('span');
    hiddenInfo.classList.add('table-hidden__info');
    hiddenInfo.innerHTML = `Таблица <strong>${tableName}</strong> cкрыта пользователем`;
    const hiddenButton = document.createElement('button');
    hiddenButton.classList.add('table-hidden__show-button');
    hiddenButton.textContent = 'Показать';
    hiddenBlock.appendChild(hiddenInfo);
    hiddenBlock.appendChild(hiddenButton);
    tableBlock.appendChild(hiddenBlock);

    hiddenButton.addEventListener('click', () => { 
      hiddenBlock.remove();
      setFilter((currentFilter) => {
        const newFilter = { ...currentFilter };
        Object.keys(newFilter).forEach(key => {
          newFilter[key] = true;
        });
        setSavedFilter({ tableName, tableIndex, filter: newFilter })
        return newFilter;
      })
    }, { once: true });
    return hiddenBlock;
  }

  /**
   * Переключает видимость таблицы в зависимости от состояния фильтра.
   * Если все столбцы скрыты, скрывает таблицу, иначе показывает таблицу и отображает информацию о скрытых столбцах.
   *
   * @param {Object} params - Объект параметров.
   * @param {HTMLElement} params.tableBlock - Блок, содержащий таблицу.
   * @param {string} params.tableName - Имя таблицы.
   * @param {number} params.tableIndex - Индекс таблицы.
   * @param {Object} params.filter - Объект фильтра, где ключ — это имя столбца, а значение — видимость этого столбца.
   * @param {Function} params.setFilter - Функция для обновления состояния фильтра.
   *
   * @returns {void}
   */
  const toggleTableVisibility = ({ 
    tableBlock, 
    tableName, 
    tableIndex, 
    filter, 
    setFilter 
  }) => {
    const isAllHidden = Object.values(filter).every(value => value === false);
    
    if (!isAllHidden) return showTable({ tableBlock });
    hideTable({ tableBlock, tableName, tableIndex, filter, setFilter });
    createHiddenTableInfo({ tableBlock, tableName, tableIndex, setFilter });
  }

  /**
   * Переключает видимость строки в зависимости от видимости её ячеек.
   * Строка скрывается, если все видимые ячейки пусты.
   *
   * @param {Object} params - Объект параметров.
   * @param {HTMLElement} params.row - Строка таблицы (tr), для которой необходимо изменить видимость.
   *
   * @returns {void}
   */
  const toggleRowVisibility = ({ row }) => {
    if(!row) return;

    const isVisibleCellsWithContent = [ ...row.children ]
      .filter((cell) => {
        const isVisible = getComputedStyle(cell).display !== 'none';
        const hasTextContent = cell.textContent.trim() !== '';
        return isVisible && hasTextContent;
      })
      .length;

    if (isVisibleCellsWithContent) 
      row.style.display = '';
    else row.style.display = 'none';
  }

  /**
   * Переключает видимость ячейки таблицы, а также скрывает или показывает границы для первого и последнего видимых столбцов.
   *
   * @param {Object} params - Объект параметров.
   * @param {HTMLElement[]} params.row - Массив ячеек строки.
   * @param {number} params.col - Индекс ячейки, которую нужно скрыть или показать.
   * @param {boolean} params.visibility - Флаг видимости ячейки.
   * @param {boolean} params.isFirstVisible - Флаг для первого видимого столбца (убирает левую границу).
   * @param {boolean} params.isLastVisible - Флаг для последнего видимого столбца (убирает правую границу).
   *
   * @returns {void}
   */
  const toggleCellVisibility = ({ 
    row, 
    col, 
    visibility, 
    isFirstVisible,
    isLastVisible 
  }) => {
    if(!row) return;
    const cell = row[col];
    if(!cell) return;
    cell.style.display = visibility ? '' : 'none';

    if (isFirstVisible)
      cell.style.borderLeft = 'none'
    if (isLastVisible)
      cell.style.borderRight = 'none'
  };

  /**
   * Обновляет видимость столбцов и строк таблицы на основе заданного фильтра.
   * 
   * @param {Object} params - Объект параметров.
   * @param {HTMLElement} params.tableBlock - Блок, содержащий таблицу, для которой применяется фильтрация.
   * @param {string} params.tableName - Имя таблицы (используется для сохранения фильтра или для других целей).
   * @param {number} params.tableIndex - Индекс таблицы (может быть полезен для многократных таблиц).
   * @param {Object} params.filter - Объект с состоянием фильтра, где ключ — это имя столбца, а значение — видимость этого столбца.
   * @param {Function} params.setFilter - Функция для обновления фильтра.
   * 
   * @description
   * Функция `mutateTableByFilter` перебирает столбцы таблицы и скрывает или показывает их в зависимости от состояния фильтра.
   * Она также управляет видимостью строк и подвала таблицы, скрывая или показывая их, когда все столбцы в строке скрыты.
   * 
   * @returns {void}
   * 
   * @example
   * mutateTableByFilter({
   *   tableBlock: document.querySelector('.table-container'),
   *   tableName: 'myTable',
   *   tableIndex: 0,
   *   filter: { 'Column1': true, 'Column2': false },
   *   setFilter: newFilter => { console.log('New filter:', newFilter); }
   * });
   */
  const mutateTableByFilter = ({ 
    tableBlock, 
    tableName, 
    tableIndex, 
    filter, 
    setFilter 
  }) => {

    const tableHeaderRow = tableBlock.querySelector('table > thead > tr'); // Элементы заголовков
    const tableRows = tableBlock.querySelectorAll('table > tbody > tr'); // Элементы строк
    const tableFootRow = tableBlock.querySelector('table > tfoot > tr'); // Элементы строки подвала
    
    const leftVisibleColIndex = [ ...tableHeaderRow?.children ].findIndex((headerCell) => {
      const headerName = headerCell.textContent.replace(/\s+/g, ' ').trim();
      const isVisible = filter[headerName];
      return isVisible;
    });
    const rightVisibleColIndex = [ ...tableHeaderRow?.children ].findLastIndex((headerCell) => {
      const headerName = headerCell.textContent.replace(/\s+/g, ' ').trim();
      const isVisible = filter[headerName];
      return isVisible;
    });

    tableHeaderRow?.children.forEach((headerCell, index) => {
      const headerName = headerCell.textContent.replace(/\s+/g, ' ').trim();
      toggleCellVisibility({ 
        row: tableHeaderRow?.children, 
        col: index, 
        visibility: filter[headerName], 
        isFirstVisible: index === leftVisibleColIndex,
        isLastVisible: index === rightVisibleColIndex
      });
      tableRows.forEach((row) => {
        toggleCellVisibility({ 
          row: row?.children, 
          col: index, 
          visibility: filter[headerName],
          isFirstVisible: index === leftVisibleColIndex,
          isLastVisible: index === rightVisibleColIndex
        });
        toggleRowVisibility({ row }); // Переключаем видимость строк
      })
      
      toggleCellVisibility({ 
        row: tableFootRow?.children, 
        col: index, 
        visibility: filter[headerName],
        isFirstVisible: index === leftVisibleColIndex,
        isLastVisible: index === rightVisibleColIndex
      });
    });

    toggleRowVisibility({ row: tableFootRow }); // Переключаем видимость подвала
    toggleTableVisibility({ tableBlock, tableName, tableIndex, filter, setFilter });
  }

  /**
   * Создает элемент формы с чекбоксом "Все", который управляет состоянием всех чекбоксов.
   * 
   * @function createCheckboxAllElement
   * 
   * @param {Object} options - Параметры для создания чекбокса.
   * @param {string} [options.label='Все'] - Текст, который будет отображён рядом с чекбоксом.
   * @param {boolean} options.value - Начальное значение состояния чекбокса (checked или unchecked).
   * @param {string} options.className - Класс, который будет добавлен к элементу чекбокса.
   * @param {Array} options.state - Массив с состоянием чекбоксов, состоящим из функций `getState`, `setState`, и `onStateChange`.
   * @param {Function} options.onChange - Функция, которая будет вызвана при изменении состояния чекбокса.
   * 
   * @returns {HTMLElement} - Возвращает элемент `label` с чекбоксом.
   * 
   * @description
   * Создает элемент с чекбоксом "Все", который управляет состоянием всех связанных чекбоксов.
   * При изменении состояния этого чекбокса, все остальные чекбоксы обновляются соответственно.
   * 
   * @example
   * const checkboxAllElement = createCheckboxAllElement({
   *   value: true,
   *   className: 'filter-checkbox-all',
   *   state: [getFilterState, setFilterState, onFilterChange],
   *   onChange: (newState) => { console.log('Filter changed:', newState); }
   * });
   */
  const createCheckboxAllElement = ({
    label = 'Все',
    value,
    className,
    state: [ getState, setState, onStateChange ],
    onChange
  }) => {

    const checkboxWrapper = document.createElement('label');
    checkboxWrapper.classList.add(className);
    const checkbox = document.createElement('input');
    checkbox.type = 'checkbox';
    checkbox.checked = value ?? Object.values(getState()).every(value => value === true);

    const handleCheckboxChange = () => {
      const currentState = getState();
      const newState = { ...currentState };
      Object.keys(newState).forEach(key => {
        newState[key] = checkbox.checked;
      });
      setState(newState);
      onChange(newState);
    }
    // Записываем состояние в объект фильтра
    checkbox.addEventListener('change', handleCheckboxChange);

    checkboxWrapper.appendChild(checkbox);
    checkboxWrapper.appendChild(document.createTextNode(label));

    if(onStateChange)
      onStateChange((newState) => {
        checkbox.checked = Object.values(newState).every(value => value === true);
      })
    return checkboxWrapper;
  }

  /**
   * Создает элемент формы с чекбоксом и управляет его состоянием.
   * 
   * @function createCheckboxElement
   * 
   * @param {Object} options - Параметры для создания чекбокса.
   * @param {string} options.label - Текст, который будет отображён рядом с чекбоксом.
   * @param {boolean} options.value - Начальное значение состояния чекбокса (checked или unchecked).
   * @param {string} options.className - Класс, который будет добавлен к элементу чекбокса.
   * @param {Array} options.state - Массив с состоянием чекбокса, состоящим из функций `getState`, `setState`, и `onStateChange`.
   * @param {Function} options.onChange - Функция, которая будет вызвана при изменении состояния чекбокса.
   * 
   * @returns {HTMLElement} - Возвращает элемент `label` с чекбоксом.
   * 
   * @description
   * Создает элемент с чекбоксом, который управляется через переданное состояние и обновляется при изменении.
   * 
   * @example
   * const checkboxElement = createCheckboxElement({
   *   label: 'Option 1',
   *   value: true,
   *   className: 'filter-checkbox',
   *   state: [getFilterState, setFilterState, onFilterChange],
   *   onChange: (newState) => { console.log('Filter changed:', newState); }
   * });
   */
  const createCheckboxElement = ({
    label,
    value,
    className,
    state: [ getState, setState, onStateChange ],
    onChange
  }) => {

    const checkboxWrapper = document.createElement('label');
    checkboxWrapper.classList.add(className);
    const checkbox = document.createElement('input');
    checkbox.type = 'checkbox';
    checkbox.checked = value;

    const handleCheckboxChange = () => {
      const currentState = getState();
      const newState = { ...currentState, [label]: checkbox.checked }
      setState(newState);
      onChange(newState);
    }
    // Записываем состояние в объект фильтра
    checkbox.addEventListener('change', handleCheckboxChange);

    checkboxWrapper.appendChild(checkbox);
    checkboxWrapper.appendChild(document.createTextNode(label));

    if(onStateChange)
      onStateChange((newState) => {
        checkbox.checked = newState[label];
      })
    return checkboxWrapper;
  }

  /**
   * Создает элемент выпадающего списка с кнопкой, иконкой и дочерними элементами.
   * 
   * @function createDropdownElement
   * 
   * @param {Object} options - Параметры для создания выпадающего списка.
   * @param {string} options.className - Класс, который будет добавлен ко всем элементам дропдауна.
   * @param {string} options.innerText - Текст, который будет отображен на кнопке.
   * @param {Object} options.icon - Объект с параметрами для иконки.
   * @param {string} options.icon.src - Путь к изображению иконки для нормального состояния.
   * @param {string} options.icon.hoverSrc - Путь к изображению иконки при наведении.
   * @param {Array} options.isOpenState - Массив с состоянием дропдауна: [getIsOpen, setIsOpen, onIsOpenChange].
   * @param {string} options.alt - Альтернативный текст для изображения иконки.
   * @param {Array<HTMLElement>} options.children - Массив дочерних элементов, которые будут добавлены в список.
   * 
   * @returns {HTMLElement|null} - Возвращает элемент выпадающего списка или `null`, если нет детей для отображения.
   * 
   * @description
   * Создает выпадающий список с кнопкой и иконкой, которая меняет изображение при наведении. 
   * При клике на кнопку открывается/закрывается список, при клике вне элемента список скрывается.
   * 
   * @example
   * const dropdown = createDropdownElement({
   *   className: 'my-dropdown',
   *   innerText: 'Options',
   *   icon: { src: 'icon.svg', hoverSrc: 'icon-hover.svg' },
   *   isOpenState: [getIsOpen, setIsOpen, onIsOpenChange],
   *   alt: 'Dropdown icon',
   *   children: [option1, option2, option3]
   * });
   */
  const createDropdownElement = ({
    className,
    innerText,
    icon: {src, hoverSrc},
    isOpenState: [ getIsOpen, setIsOpen, onIsOpenChange ],
    alt,
    children
  }) => {
    if(!children || children.length === 1) return undefined;

    onIsOpenChange((isOpen) => {
      if(isOpen) 
        return dropdownContainer.classList.add(`${className}__dropdown_active`);
      dropdownContainer.classList.remove(`${className}__dropdown_active`);
    })
    // Создаем контейнер
    const dropdown = document.createElement('article');
    dropdown.classList.add(className);

    // Создаем кнопку для раскрытия списка фильтров
    const dropdownButton = document.createElement('button');
    dropdownButton.textContent = innerText; // Название кнопки
    dropdownButton.classList.add(`${className}__button`);

    // Создаем иконку
    const img = document.createElement('img');
    img.src = `images/${src}`;
    img.alt = alt || '';
    img.classList.add(`${className}__icon`);
    dropdownButton.addEventListener('mouseenter', () => {
      img.src = `images/${hoverSrc}`;
    });
    dropdownButton.addEventListener('mouseleave', () => {
      img.src = `images/${src}`;
    });
    dropdownButton.appendChild(img);

    // Создаем контейнер для выпадающего списка
    const dropdownContainer = document.createElement('article');
    dropdownContainer.classList.add(`${className}__dropdown`);

    const dropdownList = document.createElement('ul');
    dropdownList.classList.add(`${className}__dropdown-list`);

    // Обработчик для кнопки: показывать/скрывать выпадающий список
    dropdownButton.addEventListener('click', () => {
      setIsOpen(!getIsOpen());
    });

    // Добавляем обработчик для закрытия при потере фокуса
    document.addEventListener('click', (event) => {
      if (!dropdown.contains(event.target)) {
        setIsOpen(false); // Закрываем дропдаун, если клик не внутри него
      }
    });

    dropdown.appendChild(dropdownButton);
    dropdownContainer.appendChild(dropdownList);
    dropdown.appendChild(dropdownContainer);

    children.forEach((child) => {
      const dropdownItem = document.createElement('li');
      dropdownItem.classList.add(`${className}__item`);
      dropdownItem.appendChild(child);
      dropdownList.appendChild(dropdownItem);
    })
    return dropdown;
  }

  /**
   * Создает элемент управления фильтром для таблицы.
   * 
   * @function createFilterController
   * 
   * @param {Object} options - Параметры для создания фильтра.
   * @param {string} options.tableName - Название таблицы, для которой создаётся фильтр.
   * @param {number} options.tableIndex - Индекс таблицы на странице.
   * @param {Array<string>} options.tableHeadersNames - Массив названий заголовков таблицы.
   * @param {Object} options.filter - Объект текущего состояния фильтра, где ключи — заголовки, значения — состояние (true/false).
   * @param {Array<Function>} options.filterState - Состояние фильтра, представленное в виде [getFilter, setFilter, onFilterChange].
   * 
   * @returns {HTMLElement|null} - Возвращает элемент выпадающего списка с фильтрацией или `null`, если создание невозможно.
   * 
   * @requires useState - Хук состояния для управления состоянием выпадающего списка.
   * @requires createCheckboxElement - Функция для создания чекбоксов.
   * @requires createCheckboxAllElement - Функция для создания чекбокса "Выбрать все".
   * @requires createDropdownElement - Функция для создания выпадающего меню.
   * @requires setSavedFilter - Функция для сохранения фильтра.
   */
  const createFilterController = ({ 
    tableName, 
    tableIndex, 
    tableHeadersNames, 
    filter ,
    filterState
  }) => {
    const [ getIsOpen, setIsOpen, onIsOpenChange ] = useState(false);

    const setClosedIfAllUnchecked = (filter) => {
      const isHiddenAllCols = Object.values(filter).every(value => value === false)
      if(isHiddenAllCols) setIsOpen(false);
    }
    // Создаем чекбоксы для каждого заголовка таблицы
    const checkboxAllElement = createCheckboxAllElement({
        label: 'Всe',
        className: 'col-filter__checkbox',
        state: filterState,
        onChange: (newFilter) => {
          setClosedIfAllUnchecked(newFilter);
          setSavedFilter({ tableName, tableIndex, filter: newFilter })
        }
      });
    // Создаем чекбоксы для каждого заголовка таблицы
    const checkboxElements = tableHeadersNames.map((headerName) => {
      const checkbox = createCheckboxElement({
        label: headerName,
        className: 'col-filter__checkbox',
        value: filter[headerName],
        state: filterState,
        onChange: (newFilter) => {
          setClosedIfAllUnchecked(newFilter);
          setSavedFilter({ tableName, tableIndex, filter: newFilter })
        }
      });
      return checkbox;
    });

    // Создаем кнопку и выпадающий список
    const dropdown = createDropdownElement({
      className: 'col-filter',
      icon: {
        src: 'icons/cogIcon.svg',
        hoverSrc: 'icons/cogIconFill.svg',
      },
      isOpenState: [ getIsOpen, setIsOpen, onIsOpenChange ],
      children: [checkboxAllElement, ...checkboxElements]
    });

    return dropdown;
  }
  /**
   * Добавляет функционал фильтрации столбцов для указанной таблицы.
   *
   * @function addColFilter
   * 
   * @param {Object} options - Параметры для настройки фильтрации.
   * @param {Object} options.table - Таблица с параметрами для фильтрации.
   * @param {HTMLElement} options.table.tableBlock - Блок таблицы, к которому добавляется фильтрация.
   * @param {Function} options.observerStop - Функция для остановки `MutationObserver` во время изменений.
   * @param {Function} options.observerRestart - Функция для повторного запуска `MutationObserver` после изменений.
   * 
   * @requires getInitialFilter - Функция для получения начального состояния фильтра.
   * @requires useState - Кастомный хук для управления состоянием фильтра.
   * @requires createFilterController - Функция для создания элемента управления фильтром.
   * @requires mutateTableByFilter - Функция для применения фильтров к таблице.
   */
  const addColFilter = ({
    table,
    observerStop,
    observerRestart,
  }) => {
    const { tableBlock, ...tableParams } = table;
    const initialFilter = getInitialFilter({ ...tableParams });
    // Создаем объект фильтра с состоянием чекбоксов
    const [ getFilter, setFilter, onFilterChange ] = useState({});

    const dropdown = createFilterController({ 
      ...tableParams, 
      filter: initialFilter, 
      filterState: [ getFilter, setFilter, onFilterChange ] 
    });

    if(!dropdown) return;
    // Добавляем кнопку и выпадающий список на страницу
    tableBlock.appendChild(dropdown);

    // Подписываемся на изменение состояния фильтра и передаем новый фильтр
    onFilterChange((newFilter) => {
      observerStop()
      mutateTableByFilter({ 
        tableBlock, 
        ...tableParams, 
        filter: newFilter, 
        setFilter 
      });
      observerRestart();
    });

    setFilter(initialFilter);
  };

  /**
   * Наблюдает за изменениями в DOM-элементе с классом `.report` и 
   * при обнаружении добавления или изменения дочерних элементов 
   * запускает фильтрацию столбцов в таблицах внутри этого элемента.
   *
   * @function observeReports
   * @description
   * - Использует `MutationObserver` для отслеживания изменений в дочерних элементах `.report`.
   * - При обнаружении изменений вызывает `addColFilter` для каждой таблицы.
   * - Включает функции для управления наблюдением: `observerStop` и `observerRestart`.
   * 
   * @requires debounce - Функция для предотвращения частого выполнения обратного вызова.
   * @requires getTables - Функция, которая возвращает список таблиц для обработки.
   * @requires addColFilter - Функция, которая добавляет фильтрацию к указанной таблице.
   */
  const observeReports = () => {
    const reports = document.querySelector('.report');
    const config = { childList: true, subtree: true };

    const observer = new MutationObserver((mutationsList) => {
      mutationsList.forEach(debounce((mutation) => {
        if (mutation.type === 'childList') {
          observer.disconnect();
          const tables = getTables();
          tables.forEach(table => 
            addColFilter({
              table, 
              observerStop: () => observer.disconnect(),
              observerRestart: () => observer.observe(reports, config)
            })
        );
          observer.observe(reports, config);
        }
      }));
    });
    if (reports) {
      observer.observe(reports, config);
    }
  }

  document.addEventListener("DOMContentLoaded", () => {
    const isIPhone = /iPhone/i.test(navigator.userAgent);
    if (!isIPhone) {
      observeReports();
    } else {
      console.warning('Фильтрация отчетов недоступна: устройство — iPhone');
    }
  }, 
  { once: true });
})();