const path = require(`path`);
const apiPath = `modules/api/`;

module.exports = {
    entry: {
        bundle: path.resolve(__dirname, `${apiPath}src/app.ts`)
    },
    output: {
        path: path.resolve(__dirname, `${apiPath}dist`),
        filename: 'bundle.js'
    },
    module: {
        rules: [
            {
                test: /\.tsx?$/,
                use: `ts-loader`,
                exclude: /node_modules/
            }
        ]
    },
    resolve: {
        extensions: [ `.tsx`, `.ts`, `.js` ]
    }
};
