<?php

/*
 * mail_emails - таблица содержит информацию о всех получателях писем
 *  email - email получателя письма
 *  counter_review - кол-во просмотров писем за все время
 *  counter_send_success - кол-во успешно отправленных писем
 *  counter_send_fail - кол-во неудачных попыток отправки
 *  date_last_review - дата последнего просмотра
 */
run_query("CREATE TABLE IF NOT EXISTS " . $config['table_prefix'] . "mail_emails (
  id integer(11) NOT NULL AUTO_INCREMENT,
  email varchar(255) NOT NULL UNIQUE,
  counter_review integer NOT NULL DEFAULT 0,
  counter_send_success integer NOT NULL DEFAULT 0,
  counter_send_fail integer NOT NULL DEFAULT 0,
  is_valid boolean DEFAULT NULL,
  unsubscribe boolean DEFAULT NULL,
  date_last_review timestamp DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (id)
) ENGINE=" . $config['db_engine'] . "  DEFAULT CHARSET=utf8");

// добавляем в mail_archive счетчик просмотров писем
$result = run_query("SHOW COLUMNS FROM " . $config['table_prefix'] . "mail_archive LIKE 'counter_review'");
if (!sql_fetch_assoc($result)) {
    run_query("ALTER TABLE " . $config["table_prefix"] . "mail_archive ADD counter_review integer NOT NULL DEFAULT 0");
}