<?php

use \Symfony\Component\Yaml\Yaml;

$extension_id = 'cbext.clientbase.wazzup';

/** @var \CB\Platform\ExtensionManager */
$extension_manager = \CB\Core::get(\CB\Core::EXTENSION_MANAGER);
if (!$extension_manager->isActive($extension_id)) {
    return;
}

$settings = sql_fetch_assoc(
    sql_select($config['table_prefix'] .'settings', "name='$extension_id'")
)['value'] ?? '';
$settings = Yaml::parse($settings ?? "") ?? [];

if (empty($settings)) {
    return;
}

$table = $settings['table'] ?? [];
if (
    !isset($table) ||       // если нет таблицы, то пропустим данную ревизию
    !isset($table['id']) ||
    isset($table['fields']['responsible_manager']['field_id'])
) {
    return;
}

$field_num = sql_fetch_assoc(
    sql_query("SELECT max(field_num) as num FROM {$config['table_prefix']}fields WHERE table_id={$table['id']} LIMIT 1")
)['num'] ?? 1;

$new_field_id = sql_insert($config['table_prefix'] .'fields', [
    'table_id' => $table['id'],
    'field_num' => $field_num,
    'name_field' => 'Ответственный',
    'type_field' => 7,
    'type_value' => '',
    'default_value' => 0,
    'main' => 0,
    'uniq_field' => 0,
    'javascript' => '',
    'help' => '',
    'scw_set' => '',
    'prefix' => '',
    'postfix' => '',
    '`last_value`' => '',
    'placeholder' => '',
    'mult_value' => 0,
]);

$name_field = 'f' . $new_field_id;
$field_type = \CB\CornyFunc::sql_type(7, '', 0);
$sql = "ALTER TABLE {$config['table_prefix']}data{$table['id']} ADD $name_field $field_type";
sql_query($sql);
sql_query("ALTER TABLE {$config['table_prefix']}data{$table['id']} ADD INDEX ($name_field)");

foreach(($settings['groups'] ?? ['1']) as $group) {
    sql_insert($config['table_prefix'] .'acc_fields', [
        'group_id' => $group,
        'table_id' => $table['id'],
        'field_id' => $new_field_id,
        'view_tb' => 1,
        'view_sub' => 1,
        'view_add' => 1,
        'view_edit' => 1,
        'view' => 1,
        'read_acc' => 1,
        'write_acc' => 1,
    ]);
}

$settings['table']['fields']['responsible_manager'] = [
    'field_id'   => $new_field_id,
    'short_name' => 'responsible_manager',
    'field_name' => 'Ответственный',
];

sql_update($config['table_prefix'] .'settings', [
    'value' => Yaml::dump($settings, 8, 2)
], "name='$extension_id'");
