const fields = {    
    
      
    "apps": {

        "id": {
            "type": "input-text",
        },

        "name": {
            "type": "input-text",
            "default": "",
            "is_list_name": "app",
            "required": true,
            "help": "afisharu_app_name",
        },

        "auth_token": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "afisharu_app_token",
        }
        
    },

//Сопоставление таблиц КБ и объектов внешнего приложения    
    "tables": {

        "name": {
            "type": "input-text",
            "default": "",
            "is_list_name": "table",
            "required": true,
            "help": "afisharu_table_name",
        },

        "external_object_type": {
            "type": "dropdown",
            "optionsFrom": {
                source: "options",
                field: "external_object_type"
            },
            "help": "afisharu_external_object",
            "required": true
        },

        "internal_object_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "tables"
            },
            "required": true,
            "help": "afisharu_internal_object"
        },
/*
        'fields_mapping': {
            type: "fields-mapping",
            fieldsFrom: {
                app_object: "external_object_type",
                table: "internal_object_id"
            }
        }        
*/
    },

    "connectors": {



        "name": {
            "type": "input-text",
            "default": "",
            "is_list_name": "connector",
            "required": true,
            "help": "afisharu_connector_name",
        },

        "external_app_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "list",
                field: "apps",
                value: "id",
                label: "name"
            },
            "required": true,
            "help": "afisharu_app",  
        },

/*        
        "type": {
            "type": "radiobutton",
            "options": {
                "sync": "connector_type_sync",
                "out": "connector_type_out",
                "in": "connector_type_in",
            },
            "required": true   
        },
*/

        "internal_action": {
            "type": "dropdown",
            "options": {
                "none": "Ничего не делать",
                "create": "Создать запись",
                "update": "Обновить запись",
                "updatecreate": "Обновить запись или создать новую",
                "delete": "Удалить запись"
            },
            "default": "none",
            "required": true,
            "help": "afisharu_internal_action"
        },   
        
        "object_mapping_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "list",
                field: "tables",
                value: "id",
                label: "name"
            },
            "required": true,
            "help": "afisharu_table"
        },        


        "external_action": {
            "type": "dropdown",
            "optionsFrom": {
                source: "options",
                field: "object_mapping_id",
                optionsDir: "actions",
                from_list: "tables",
                from_list_options: "external_object_type"
            },
            "required": true,
            "help": "afisharu_external_action"
        },        

        calc: {
            type: "html",
        },

        cron: {
            type: "html",
        }
    }

}

export default fields;