//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [

    //Уровень 1: вкладки
    {

        //header - Название вкладки (не забываем добавлять строки в locale)
        header: "tab_all_fields",

        //forms - Формы: на вкладке может быть несколько форм
        forms: [

            //Уровень 2: форма
            {
                //header - заголовок формы, не обязательно
                header: 'all_fields_examples',

                //formBlocks - блоки формы
                formBlocks: [
                    {
                        message: {
                            template: "Модуль Yandex Smart Captcha не активирован",
                            status: "success"
                        }
                    },
                    {
                        message: {
                            template: "Вы активировали модуль Yandex Smart Captcha",
                            status: 'default'
                        }
                    },
                    //Уровень 3: блок формы
                    {

                        //header - заголовок блока, не обязательно
                        header: 'text_fields_examples',

                        //formLines - строки формы
                        formLines: [

                            //Уровень 4: строка формы
                            {

                                //Label строки, обязательно
                                label: "field_hello",
                                
                                //Список полей (в одной строке может быть несколько полей)
                                fields: ['hello']

                            },                            

                            //Уровень 4: строка формы
                            {

                                //Label строки, обязательно
                                label: "field_text",
                                
                                //Список полей (в одной строке может быть несколько полей)
                                fields: ['example-text'],

                                //Идентификатор помощи, не обязательно
                                help: 'Plus_mail'

                            },

                            {
                                label: "example-password-label",
                                fields: ["example-password"]
                            },

                            {

                                //Label строки, обязательно
                                label: "field_textarea",
                                
                                //Список полей (в одной строке может быть несколько полей)
                                fields: ['example-textarea'],

                            },        
                            
                            {

                                //Label строки, обязательно
                                label: "field_date",
                                
                                //Список полей (в одной строке может быть несколько полей)
                                fields: ['example-date'],

                            },
                            
                            {

                                //toggle: ссылка открытия/закрытия поля
                                toggle: "toggle_more",

                                //Label строки, обязательно
                                label: "field_datetime",
                                
                                //Список полей (в одной строке может быть несколько полей)
                                fields: ['example-datetime'],

                            }                             


                        ],

                        buttons: [
                            {
                                label: "Кнопка 1",
                                apiAction: "/api/dev/cbext/clientbase/extension_template/helloworld",
                                messageIndex: "message"
                            },
                            {
                                label: "Кнопка 2",
                                apiAction: "/api/dev/cbext/clientbase/extension_template/hellouser",
                                messageIndex: "message"
                            }
                        ]

                    },


                    //Уровень 3: блок формы, пример без formLines
                    {

                        header: 'logic_fields_examples',

                        //fields - список полей в блоке. formLines будет сформирован автоматически из полей.
                        fields: ['example-checkbox']

                    },


                    //Уровень 3: блок формы, пример c toggle
                    {

                        //toggle - ссылка открытия/закрытия блока
                        toggle: 'select_fields_examples',

                        //fields - список полей в блоке. formLines будет сформирован автоматически из полей.
                        fields: ['example-checkbox-multi', 'example-radiobutton', 'example-dropdown']

                    },


                    //Уровень 3: блок формы
                    {
                        header: 'link_fields_examples',

                        formLines: [
                            //Уровень 4: строка формы
                            {
                                fields: ["example-link"],
                                label: "example-link-label",
                                link: "https://clientbase.ru/",
                                linkText: "example-link-text"
                            }
                        ]
                    }
                ]

            },


            //Уровень 2: Форма, пример без formBlocks

            {

                header: 'table_fields_examples',

                //fields - список полей в форме, formBlocks и formLines будут сформированы автоматически
                fields: ['example-dropdown-table', 'example-dropdown-fields', 'example-dropdown-fields-type']


            },


            //Уровень 2: Форма, пример с toggle

            {
                
                //toggle - ссылка открытия/закрытия формы
                toggle: 'access_rights',

                fields: ['example-radio-groups']

            }

        ]

    },


    //Уровень 1: Вкладка, пример с формой-списком
    {

        header: 'tab_listform',

        forms: [

            {

                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "example-list",

                //addButton: текст ссылки добавления нового элемента
                addButton: "listform_add",

                //listFields - поля, которые будут выведены в списке
                listFields: ['example-list-name', 'example-list-fname'],

                //Форма добавления/редактирования может быть задана через formBlocks, formLines, fields
                //Для краткости примера создаем через fields
                fields: ['example-list-fname', 'example-list-name', 'example-list-sname']

            }

        ]

    },


    //Уровень 1: Вкладка, пример с показом в зависимости от значения поля
    //showOn и showOnValue доступны во всех типах элементов: формы, блоки, строки, поля
    {

        header: 'tab_showon',

        forms: [

            {
                formBlocks: [

                    {

                        formLines: [

                            {

                                label: 'check_to_show_line',
                                fields: ['example-checkbox']

                            },

                            {

                                label: 'field_text',

                                //Строка формы будет показана при не пустом значении поля example-checkbox
                                showOn: 'example-checkbox',
                                fields: ['example-text']

                            },

                            {

                                label: 'select_to_show_block',
                                fields: ['example-dropdown']

                            }


                        ]

                    },


                    {

                        //Блок будет показан при значении поля example-dropdown = 2
                        showOn: 'example-dropdown',
                        showOnValue: '2',
                        fields: ['example-textarea']

                    }


                ]


            }



        ]




    },


    //Уровень 1: Вкладка, пример сокращенной записи
    {

        header: 'tab_short',

        //Во вкладке можно указать сразу fields, 
        fields: ['example-text', 'example-dropdown', 'example-textarea']

    }

];

export default composition;