//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [
    {
        
        header: "cloud_storage",        

        forms: [

            {
                showOn: "status",
                showOnValue: "off",
                header: "Добавление хранилища",
                formBlocks: [

                    {

                        formLines: [

                            {
                                label: "s3-service",
                                fields: ["s3-service"],
                                help: 'help_s3-service'
                            },            

                            {
                                showOn: "s3-service",
                                label: "s3-url",
                                showOnValue: "_other",
                                fields: ["s3-url"],
                                help: 'help_s3-url'
                            },
                            {
                                showOn: "s3-service",
                                label: "s3-region",
                                showOnValue: "_other",
                                fields: ["s3-region"],
                                help: 'help_s3-region'
                            },   
                            {
                                label: "s3-key",
                                fields: ["s3-key"],
                                help: 'help_s3-key'
                            },
                            {
                                label: "s3-secretkey",
                                fields: ["s3-secretkey"],
                                help: 'help_s3-secretkey'
                            },
                        ],
                    },
                    {
                        header: "Настройки хранения",
                        formLines: [
                            {
                                label: "storage-type",
                                fields: ["storage-type"],
                                help: 'help_storage-typec'
                            },
                            {
                                label: "s3-table",
                                fields: ["s3-table"],
                                help: "help_s3-table"
                            },
                        ],
                    },
                    {
                        header: "Корзина (Bucket)",
                        formLines: [
                            {
                                label: "s3-bucket",
                                fields: ["s3-bucket"],
                                help: "help_s3-bucket"
                            },
                            {
                                label: "s3-bucket_name",
                                fields: ["s3-bucket_name"],
                                help: 'help_s3-bucket_name'
                            },
                        ],
                        
                    },
                    {
                        showOn: "error_backet",
                        showOnValue: "1",
                        message: {
                            template: "Корзина не существует",
                            status: "warning"
                        },
                    },
                    {
                        showOn: "error_backet",
                        showOnValue: "2",
                        message: {
                            template: "Корзина существует",
                            status: "warning"
                        },
                    },
                    {
                        header: "Дополнительно",
                        formLines: [
                            {
                                
                                label: "s3-reference",
                                fields: ["s3-reference"],
                                help: 'help_s3-reference'
                            }
                        ]
                    },
                    {
                        message: {
                            template: "Внимание! Нажимая на кнопку “Подключить хранилище” вы запускаете фоновый процесс миграции (копирования) файлов из вашего аккаунта Кб в стороннее облачное хранилище. Длительность процесса будет зависеть от объема переносимых файлов.",
                            status: "warning",
                            width: "400"
                        },
                    },
                ],
            },
            {
                showOn: "status",
                showOnValue: ["progress", "paused", "transferred", "on"],
                header: "Текущее хранилище",
                saveButton: false,
                formBlocks: [
                    {
                        message: {
                            template: "{{cloud_name}}, {{s3-bucket_name}}, {{type_storage}}, {{table_storage}}",
                            width: "300"
                        },
                    },
                    {
                        showOn: "status",
                        showOnValue: "progress",
                        message: {
                            template: "Статус: Идет миграция",
                        },
                    },
                    {
                        showOn: "status",
                        showOnValue: "paused",
                        message: {
                            template: "Статус: Миграция приостановлена",
                        },
                    },
                    {
                        showOn: "status",
                        showOnValue: "transferred",
                        message: {
                            template: "Статус: Файлы скопированы, ожидание завершения миграции",
                        },
                    },
                    {
                        showOn: "status",
                        showOnValue: "on",
                        message: {
                            template: "Статус: Подключено",
                        },
                    },
                    {
                        showOn: "status",
                        showOnValue: "on",
                        message: {
                            template: "Объем: {{size_files}} Гб",
                        },
                    },
                    {
                        showOn: "status",
                        showOnValue: ["progress", "paused", "transferred"],
                        message: {
                            template: "Перенесено: {{size_end_migration}} из {{size_migration_files}} Гб",
                        },
                    },
                    {
                        buttons: [
                            {
                                label: "Пауза",
                                showOn: 'status',
                                showOnValue: 'progress',
                                apiAction: "/api/dev/cbext/clientbase/external_storage/pause",
                                messageIndex: "message"
                            },
                            {
                                label: "Возобновить",
                                showOn: 'status',
                                showOnValue: 'paused',
                                apiAction: "/api/dev/cbext/clientbase/external_storage/pause",
                                messageIndex: "message"
                            },
                            {
                                label: "Завершить миграцию и удалить локальные файлы",
                                showOn: 'status',
                                showOnValue: 'transferred',
                                apiAction: "/api/dev/cbext/clientbase/external_storage/complete",
                                messageIndex: "message"
                            },
                            {
                                label: "Отменить миграцию",
                                showOn: 'status',
                                showOnValue: ["progress", "paused", "transferred"],
                                apiAction: "/api/dev/cbext/clientbase/external_storage/delete",
                                messageIndex: "message"
                            },
                            {
                                label: "Отключить хранилище",
                                showOn: 'status',
                                showOnValue: 'on',
                                apiAction: "/api/dev/cbext/clientbase/external_storage/deactiv",
                                messageIndex: "message"
                            },
                        ]

                    },

                    {
                        message: {
                            showOn: 'status',
                            showOnValue: 'progress',
                            template: "Внимание! При небходимости вы можете либо приостановить миграцию с возможностью возобновить позднее, либо полностью отменить ее. Процесс отмены необратим, миграцию потребуется начинать заново.",
                            status: "warning",
                            width: "400"
                        },
                    },
                    {
                        message: {
                            showOn: 'status',
                            showOnValue: 'transferred',
                            template: "Внимание! Нажимая на кнопку “Завершить миграцию”, вы удаляете все локальные файлы из аккаунта Кб, оставляя их только во внешнем хранилище. Перед завершением миграции настоятельно рекомендуется сделать полный внешний бэкап аккаунта со всеми файлами и сохранить его в надежном месте, на случай возможного восстановления.",
                            status: "warning",
                            width: "400"
                        },
                    },
                    {
                        message: {
                            showOn: 'status',
                            showOnValue: 'on',
                            template: "Внимание! Нажимая на кнопку “Отключить хранилище”, вы запускаете необратимый процесс обратной миграции файлов из внешнего хранилища в аккаунт Кб. После отключения хранилища и копирования файлов обратнов в Кб, файлы расположенные в хранилище требуется удалить самостоятельно.",
                            status: "warning",
                            width: "400"
                        },
                    },
                   
                ]
            }
        ]

    },
    {
        
        header: "cloud_table",        
        forms: [
            {
                showOn: "edit_viw_table",
                showOnValue: "1",
                header: "Добавление таблицы",
                listForm: true,
                listFields: ["cloud-table"],
                field: "table-list",
                addButton: "add_table",
                formBlocks: [
                    {
                        formLines: [
                            {
                                fields: ["cloud-table"],
                                label: "table-destination",
                                help: "storage-table"
                            }
                        ]
                    },
                    {
                    header: "Дополнительно",
                        formLines: [
                            {
                                
                                label: "table-reference",
                                fields: ["table-reference"],
                                help: 'help_table-reference'
                            }
                        ]
                    },
                    {
                        showOn: "migration_error",
                        showOnValue: "1",
                        message: {
                            template: "Необходимо завершить миграцию перемещения файлов из аккаунта Кб во внешнее хранилище.",
                            status: "warning",
                        },
                    },
                    {
                        showOn: "migration_error",
                        showOnValue: "1",
                        message: {
                            template: "Необходимо завершить миграцию перемещения файлов из аккаунта Кб во внешнее хранилище.",
                            status: "warning",
                        },
                    }
                ]
            },
            {
                showOn: "edit_viw_table",
                showOnValue: "2",
                saveButton: false,
                header: "Подготовка таблиц",
                formBlocks: [
                    {
                        message: {
                            template: "Идет процесс миграции файлов. Необходимо завершить миграцию во вкладке Хранилища."
                        },
                    }
                ]
            },
            {
                showOn: "edit_viw_table",
                showOnValue: "0",
                header: "Подготовка таблиц",
                saveButton: false,
                formBlocks: [
                    {
                        message: {
                            template: "Возможность выбора таблиц не предусмотрена в хранилище."
                        },
                    }
                ]
            },
            {
                showOn: "edit_viw_table",
                showOnValue: "3",
                saveButton: false,
                header: "Подготовка таблиц",
                formBlocks: [
                    {
                        message: {
                            template: "Возможность выбора таблиц будет доступна после сохранения вкладки хранилища."
                        },
                    }
                ]
            }
        ]

    }
];

export default composition;