import AddUserComponent from './AddUserComponent.js';
import GroupComponent from './GroupComponent.js';
import UsersTableComponent from './UsersTableComponent.js';
import useAccessTabWazzupExtensionStore from './../../store/useAccessTabWazzupExtensionStore.js';


/**
 * Вкладка доступы
 */
export const AccessComponent = {
  name: 'access-component',

  components: {
    'add-user-component':    AddUserComponent,
    'users-table-component': UsersTableComponent,
    'group-component':       GroupComponent,
  },

  setup(props, { emit }) {
    const accessStore = useAccessTabWazzupExtensionStore();

    Vue.onMounted(() => {
      accessStore.loadUsers();
      checkHelpButtonsOnCurrentPage();
      bind_help_bt('wazzup');
    });
  },

  template: /*html*/`
    <add-user-component />
    <hr style="width: 50%;">
    <users-table-component />
    <hr style="width: 50%;">
    <group-component />
  `
}
