
import Label from "../../shared/Label/Label.js"
import FormField from "./FormField/FormField.js"
import { formBaseElement } from "../../formBaseElement.js";
import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import FormLineStyles from './FormLineStyles.js';

const FormLine = {
  name: 'edit-form-line',
  data() {
    return {
      componentClass: 'editform-line',
    }
  },
  components: {
    FormField,
    Label
  },
  mixins: [formBaseElement, useScopedStyleMixin, FormLineStyles],
  props: {
    table: String
  },
  methods: {
    handleSelect(option) {
      if(option.source === 'tables' || option.source === 'subtables')
        this.$emit('selectTable', option);
    },
  },
  computed: {
    computedHelp() {
      // Если есть element.help, возвращаем его
      if (this.element.help) {
        return this.element.help;
      }
      
      // Иначе ищем help в полях element.fields
    for (const fieldId of this.element.fields) {
        const field = this.actualFieldsSource[fieldId];
        if (field && field.help) {
          return field.help;
        }
    }
      
      // Если ничего не найдено, возвращаем пустую строку
      return '';
    }
  },
  template: /*html*/`
    <template v-if="showOn">
      <div v-if="toggleLink" class="editform-toggle">
        <a href="#" v-on:click="toggle" :class="hidden ? '' : 'open'">{{$t(toggleLink)}}</a>
      </div>
      <div v-if="toggleShow" :class="componentClass + hash">
        <div :class="componentClass + hash + '__label'">
          <Label
            :label="element.label" 
            :help="computedHelp" 
          />
        </div>
        <div :class="componentClass + hash + '__fields'">
          <FormField 
            v-for="field in element.fields" 
            :link="{ 
              href: element.link, 
              text: element.linkText,
            }" 
            :dataSource="dataSource" 
            :fieldsSource="fieldsSource"  
            :storeFieldId="field" 
            :table="table"
            @change="handleSelect"
          />
        </div>
      </div>
    </template>
  `
};
export default FormLine