const CalcConditions = {
  methods: {
    generateStyles() {
      return `
        .${this.componentClass}${this.hash} {
          display: flex;
          align-items: baseline;
          gap: 5px;
          width: 100%;
        }
        .${this.componentClass}__label${this.hash} {
          flex: 0 0 50%;
          display: flex;
          align-items: center;
          justify-content: flex-end;
          gap: 5px;
        }
        .${this.componentClass}__items${this.hash} {
          flex: 0 0 50%;
          display: flex;
          flex-direction: column;
          align-items: flex-start;
          justify-content: flex-start;
          gap: 5px;
        }
        .${this.componentClass}__item${this.hash} {
          flex: none;
          display: flex;
          align-items: center;
          justify-content: flex-start;
          gap: 5px;
          position: relative;
        }
        .${this.componentClass}__item${this.hash}:not(:first-child)::before { content: 'или';
          position: absolute;
          left: -5px;
          transform: translateX(-100%);
          white-space: nowrap;
          z-index: 1;
        }
        .${this.componentClass}__condition-type-selector${this.hash} {
          width: 206px;
        }
        .${this.componentClass}__condition-interval-selector${this.hash} {
          width: 206px;
        }
      `
    }
  }
};

export default CalcConditions;