import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import EditButtonStyles from './EditButtonStyles.js';

const EditButton = {
  template: /*html*/`
    <button
      :class="componentClass + hash"
      @click="onClick" 
      :title="$t('editform_button_edit')"
    >
      <img src="images/b_edit.png">
    </button>
  `,
  name: 'edit-button',
  props: {
    index: Number,
  },
  data() {
    return {
      componentClass: 'edit-button',
    }
  },
  mixins: [useScopedStyleMixin, EditButtonStyles],
  methods: {
    onClick(e) {
      e.preventDefault();
      this.$emit('click', this.index, e);
    },
  },
};

export default EditButton