import useKOSearchBlockStore from "./../store/index.js";
import useFetch from "./useFetch.js";


/**
 * выводить X последних строк.
 * @param {FormData} form_data
 * @returns {void}
 */
async function getLastLine( form_data) {
  form_data.append('last_lines', true);
  let result = await useFetch(window.location.search, form_data);
  return result[0] || [];
}


/**
 * Получение данных с сервера.
 * @param {Pinia} store
 * @param {FormData} form_data
 * @returns {void}
 */
async function getData(store, form_data) {
  form_data.append('search_type', store.search_type);
  form_data.append('value', store.search_string);

  let result = await useFetch(window.location.search, form_data);

  if (store.block_name in window['search_block_values']) {
    window['search_block_values'][store.block_name] = '';
  }

  window['search_type'] = {
    'search_type': store.search_type
  }
  window['search_block_values'][store.block_name] = store.search_string;

  return result[0] || [];
}


/** Выполнить поиск данных */
export default async function(need_last_lines) {
  const last_lines = ( // выводить X последних строк
    typeof need_last_lines === 'boolean' ? need_last_lines : false
  );

  const store = useKOSearchBlockStore();
  if (!last_lines && typeof store.search_string !== 'string') {
    console.error('useSearch: search_string is not a string');
    return [];
  }

  // начинаем искать от двух символов
  if ((!last_lines && store.search_string == '') || store.search_string.length < 2) {
    return [];
  }

  // данные в запрос
  const form_data = new FormData();
  form_data.append('csrf',  csrf);
  form_data.append('get_json_data', store.block_id);

  if (last_lines) {
    return getLastLine(form_data);
  } else {
    return getData(store, form_data);
  }
}
