<script>
    {literal}
    function strtotime(str, now) {
        // http://kevin.vanzonneveld.net
        // +   original by: Caio Ariede (http://caioariede.com)
        // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
        // +      input by: David
        // +   improved by: Caio Ariede (http://caioariede.com)
        // +   improved by: Brett Zamir (http://brett-zamir.me)
        // +   bugfixed by: Wagner B. Soares
        // +   bugfixed by: Artur Tchernychev
        // +   input by: wookie
        // %        note 1: Examples all have a fixed timestamp to prevent tests to fail because of variable time(zones)
        // *     example 1: strtotime('+1 day', 1129633200);
        // *     returns 1: 1129719600
        // *     example 2: strtotime('+1 week 2 days 4 hours 2 seconds', 1129633200);
        // *     returns 2: 1130425202
        // *     example 3: strtotime('last month', 1129633200);
        // *     returns 3: 1127041200
        // *     example 4: strtotime('2009-05-04 08:30:00');
        // *     returns 4: 1241418600
        var i, l, match, s, parse = '';

        str = (str + '').replace(/\s{2,}|^\s|\s$/g, ' ').replace(/[\t\r\n]/g, ''); // unecessary spaces and chars

        if (str === 'now') {
            return now === null || isNaN(now) ? new Date().getTime() / 1000 | 0 : now | 0;
        } else if (!isNaN(parse = Date.parse(str))) {
            return parse / 1000 | 0;
        } else if (now) {
            now = new Date(now * 1000); // Accept PHP-style seconds
        } else {
            now = new Date();
        }

        str = str.toLowerCase();

        var __is = {
            day: {
                'sun': 0,
                'mon': 1,
                'tue': 2,
                'wed': 3,
                'thu': 4,
                'fri': 5,
                'sat': 6
            },
            mon: [
                'jan',
                'feb',
                'mar',
                'apr',
                'may',
                'jun',
                'jul',
                'aug',
                'sep',
                'oct',
                'nov',
                'dec'
            ]
        };

        var process = function (m) {
            var ago = (m[2] && m[2] === 'ago');
            var num = (num = m[0] === 'last' ? -1 : 1) * (ago ? -1 : 1);

            switch (m[0]) {
                case 'last':
                case 'next':
                    switch (m[1].substring(0, 3)) {
                        case 'yea':
                            now.setFullYear(now.getFullYear() + num);
                            break;
                        case 'wee':
                            now.setDate(now.getDate() + (num * 7));
                            break;
                        case 'day':
                            now.setDate(now.getDate() + num);
                            break;
                        case 'hou':
                            now.setHours(now.getHours() + num);
                            break;
                        case 'min':
                            now.setMinutes(now.getMinutes() + num);
                            break;
                        case 'sec':
                            now.setSeconds(now.getSeconds() + num);
                            break;
                        case 'mon':
                            if (m[1] === "month") {
                                now.setMonth(now.getMonth() + num);
                                break;
                            }
                            // fall through
                        default:
                            var day = __is.day[m[1].substring(0, 3)];
                            if (typeof day !== 'undefined') {
                                var diff = day - now.getDay();
                                if (diff === 0) {
                                    diff = 7 * num;
                                } else if (diff > 0) {
                                    if (m[0] === 'last') {
                                        diff -= 7;
                                    }
                                } else {
                                    if (m[0] === 'next') {
                                        diff += 7;
                                    }
                                }
                                now.setDate(now.getDate() + diff);
                                now.setHours(0, 0, 0, 0); // when jumping to a specific last/previous day of week, PHP sets the time to 00:00:00
                            }
                    }
                    break;

                default:
                    if (/\d+/.test(m[0])) {
                        num *= parseInt(m[0], 10);

                        switch (m[1].substring(0, 3)) {
                            case 'yea':
                                now.setFullYear(now.getFullYear() + num);
                                break;
                            case 'mon':
                                now.setMonth(now.getMonth() + num);
                                break;
                            case 'wee':
                                now.setDate(now.getDate() + (num * 7));
                                break;
                            case 'day':
                                now.setDate(now.getDate() + num);
                                break;
                            case 'hou':
                                now.setHours(now.getHours() + num);
                                break;
                            case 'min':
                                now.setMinutes(now.getMinutes() + num);
                                break;
                            case 'sec':
                                now.setSeconds(now.getSeconds() + num);
                                break;
                        }
                    } else {
                        return false;
                    }
                    break;
            }
            return true;
        };

        match = str.match(/^(\d{2,4}-\d{2}-\d{2})(?:\s(\d{1,2}:\d{2}(:\d{2})?)?(?:\.(\d+))?)?$/);
        if (match !== null) {
            if (!match[2]) {
                match[2] = '00:00:00';
            } else if (!match[3]) {
                match[2] += ':00';
            }

            s = match[1].split(/-/g);

            s[1] = __is.mon[s[1] - 1] || s[1];
            s[0] = +s[0];

            s[0] = (s[0] >= 0 && s[0] <= 69) ? '20' + (s[0] < 10 ? '0' + s[0] : s[0] + '') : (s[0] >= 70 && s[0] <= 99) ? '19' + s[0] : s[0] + '';
            return parseInt(this.strtotime(s[2] + ' ' + s[1] + ' ' + s[0] + ' ' + match[2]) + (match[4] ? match[4] / 1000 : ''), 10);
        }

        var regex = '([+-]?\\d+\\s' + '(years?|months?|weeks?|days?|hours?|min|minutes?|sec|seconds?' + '|sun\\.?|sunday|mon\\.?|monday|tue\\.?|tuesday|wed\\.?|wednesday' + '|thu\\.?|thursday|fri\\.?|friday|sat\\.?|saturday)' + '|(last|next)\\s' + '(years?|months?|weeks?|days?|hours?|min|minutes?|sec|seconds?' + '|sun\\.?|sunday|mon\\.?|monday|tue\\.?|tuesday|wed\\.?|wednesday' + '|thu\\.?|thursday|fri\\.?|friday|sat\\.?|saturday))' + '(\\sago)?';

        match = str.match(new RegExp(regex, 'gi')); // Brett: seems should be case insensitive per docs, so added 'i'
        if (match === null) {
            return false;
        }

        for (i = 0, l = match.length; i < l; i++) {
            if (!process(match[i].split(' '))) {
                return false;
            }
        }

        return now.getTime() / 1000 | 0;
    }
    {/literal}

    function set_date_promt(rule_id, num) {
        if ($('#cond_value_' + rule_id + '_' + num).val() == 'curdate()' || $('#cond_value_' + rule_id + '_' + num).val() == 'now()'
            || $('#cond_value_' + rule_id + '_' + num).val() == 'week()' || $('#cond_value_' + rule_id + '_' + num).val() == 'half_month()'
            || $('#cond_value_' + rule_id + '_' + num).val() == 'month()' || $('#cond_value_' + rule_id + '_' + num).val() == 'year()'
            || ($('#cond_value_' + rule_id + '_' + num).val() == 'fix_date' && $('#cond_date_' + rule_id + '_' + num).val())) {
            var date_type = $('#cond_value_' + rule_id + '_' + num).val();
            switch (date_type) {
                case 'week()':
                    var date0 = {$begin_week};
                    var date0_end = {$end_week};
                    break
                case 'half_month()':
                    var date0 = {$begin_half_month};
                    var date0_end = {$end_half_month};
                    break
                case 'month()':
                    var date0 = {$begin_month};
                    var date0_end = {$end_month};
                    break
                case 'year()':
                    var date0 = {$begin_year};
                    var date0_end = {$end_year};
                    break
                case 'fix_date':
                    var date0 = strtotime($('#cond_date_' + rule_id + '_' + num).val());
                    var date0_end = strtotime($('#cond_date_' + rule_id + '_' + num).val());
                    break
                default:
                    var date0 = strtotime('now');
                    var date0_end = strtotime('now');
                    break
            }
            if ($('#cond_oper_' + rule_id + '_' + num).val() == " + interval ") {
                if ($('#cond_interval_' + rule_id + '_' + num).val() && $('#cond_period_' + rule_id + '_' + num).val()) {
                    var inter0 = '+' + $('#cond_interval_' + rule_id + '_' + num).val() + ' ' + $('#cond_period_' + rule_id + '_' + num).val();
                    inter1 = strtotime(inter0, date0);
                    var date1 = new Date(inter1 * 1000);
                    inter_end = strtotime(inter0, date0_end);

                    if ((date_type == 'month()') && ($('#cond_period_' + rule_id + '_' + num).val() == ' month'))
                        var date1_end = new Date(date1.getFullYear(), date1.getMonth(), new Date(date1.getFullYear(), date1.getMonth() + 1, 0).getDate(), 23, 59, 59);
                    else
                        var date1_end = new Date(inter_end * 1000);
                } else {
                    return false;
                }
            } else if ($('#cond_oper_' + rule_id + '_' + num).val() == " - interval ") {
                if ($('#cond_interval_' + rule_id + '_' + num).val() && $('#cond_period_' + rule_id + '_' + num).val()) {
                    var inter0 = '-' + $('#cond_interval_' + rule_id + '_' + num).val() + ' ' + $('#cond_period_' + rule_id + '_' + num).val();
                    inter1 = strtotime(inter0, date0);
                    var date1 = new Date(inter1 * 1000);
                    inter_end = strtotime(inter0, date0_end);

                    if ((date_type == 'month()') && ($('#cond_period_' + rule_id + '_' + num).val() == ' month'))
                        var date1_end = new Date(date1.getFullYear(), date1.getMonth(), new Date(date1.getFullYear(), date1.getMonth() + 1, 0).getDate(), 23, 59, 59);
                    else
                        var date1_end = new Date(inter_end * 1000);
                } else {
                    return false;
                }
            } else {
                var date1 = new Date(date0 * 1000);
                var date1_end = new Date(date0_end * 1000);
            }

            if ((date1.getDate()).toString().length == 2) {
                var toDay = (date1.getDate()).toString();
            } else {
                var toDay = '0' + (date1.getDate()).toString();
            }

            if ((date1.getMonth() + 1).toString().length == 2) {
                var month = (date1.getMonth() + 1).toString();
            } else {
                var month = '0' + (date1.getMonth() + 1).toString();
            }

            if ((date1.getHours()).toString().length == 2) {
                var Hours = (date1.getHours()).toString();
            } else {
                var Hours = '0' + (date1.getHours()).toString();
            }

            if ((date1.getMinutes()).toString().length == 2) {
                var Minutes = (date1.getMinutes()).toString();
            } else {
                var Minutes = '0' + (date1.getMinutes()).toString();
            }

            if ((date1.getSeconds()).toString().length == 2) {
                var Seconds = (date1.getSeconds()).toString();
            } else {
                var Seconds = '0' + (date1.getSeconds()).toString();
            }

            var date2 = date1.getFullYear().toString() + '-' + month + '-' + toDay + ' ' + Hours + ':' + Minutes + ':' + Seconds;

            if ((date1_end.getDate()).toString().length == 2) {
                var toDay = (date1_end.getDate()).toString();
            } else {
                var toDay = '0' + (date1_end.getDate()).toString();
            }

            if ((date1_end.getMonth() + 1).toString().length == 2) {
                var month = (date1_end.getMonth() + 1).toString();
            } else {
                var month = '0' + (date1_end.getMonth() + 1).toString();
            }

            if ((date1_end.getHours()).toString().length == 2) {
                var Hours = (date1_end.getHours()).toString();
            } else {
                var Hours = '0' + (date1_end.getHours()).toString();
            }

            if ((date1_end.getMinutes()).toString().length == 2) {
                var Minutes = (date1_end.getMinutes()).toString();
            } else {
                var Minutes = '0' + (date1_end.getMinutes()).toString();
            }

            if ((date1_end.getSeconds()).toString().length == 2) {
                var Seconds = (date1_end.getSeconds()).toString();
            } else {
                var Seconds = '0' + (date1_end.getSeconds()).toString();
            }

            var date2_end = date1_end.getFullYear().toString() + '-' + month + '-' + toDay + ' ' + Hours + ':' + Minutes + ':' + Seconds;

            switch (date_type) {
                case 'week()':
                case 'half_month()':
                case 'month()':
                case 'year()':
                    var date3 = lang['since_from'] + ' ' + date2 + ' ' + lang['since_to'] + ' ' + date2_end;
                    break
                default:
                    var date3 = date2;
                    break
            }

            if ($('#cond_value_' + rule_id + '_' + num).val() == 'curdate()') {
                pos_time = date2.indexOf(' ');
                date3 = date2.substr(0, pos_time + 1);
            }
            var term = $('#cond_term_' + rule_id + '_' + num).val();
            switch (term) {
                case '=':
                    var field_str = date3;
                    break
                case '!=':
                    var field_str = lang['none'] + ' ' + date3;
                    break
                case '>':
                    var field_str = lang['later_than'] + ' ' + date3;
                    break
                case '<':
                    var field_str = lang['earlier_than'] + ' ' + date3;
                    break
                case '>=':
                    var field_str = date3 + ' ' + lang['or_later'];
                    break
                case '<=':
                    var field_str = date3 + ' ' + lang['or_earlier'];
                    break
                case ' like ':
                    var field_str = lang['contains'] + ' ' + date3;
                    break
                case ' not like ':
                    var field_str = lang['does_not_contain'] + ' ' + date3;
                    break
            }
            $('#date_promt_' + rule_id + '_' + num).html(field_str + " <span class='help_bt' style='height:16px' title='" + lang.now_tip + "'>");
        }
        else {
            $('#date_promt_' + rule_id + '_' + num).html('');
        }

        if ($('#cond_value_' + rule_id + '_' + num).val() == 'fix_date') {
            $('#date_value_' + rule_id + '_' + num).css("display", "");
        } else {
            $('#date_value_' + rule_id + '_' + num).css("display", "none");
        }

        $('.dtpicker').datetimepicker({
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            timeFormat: 'HH:mm:ss',
            showAlways: true,
            buttonImage: 'images/calbtn.png',
            buttonImageOnly: true,
            buttonText: 'Calendar',
            showAnim: (('\v' == 'v') ? '' : 'show'),  // в ie не включаем анимацию, тормозит
        }).css('width', '120px');

        const condFieldId = $('#cond_field_' + rule_id + '_' + num).val();
        const condTermVal = $('#cond_term_' + rule_id + '_' + num).val();
        const field = search_fields[condFieldId];
        const fieldType = parseInt(field.type_field);
        const fieldMultVal = parseInt(field.mult_value);
        const isTermFocused = $('#cond_term_' + rule_id + '_' + num).is(':focus');

        if (condTermVal === '=' && isTermFocused) checkFieldForMultiValAndShowTooltip(fieldType, fieldMultVal, 1);
        if (condTermVal === '!=' && isTermFocused) checkFieldForMultiValAndShowTooltip(fieldType, fieldMultVal, 2);
    }

    // ============ МАСТЕР УСЛОВИЙ ============ //

    var last_num = { {foreach from=$set_cond_array item=set_cond key=arr_num}{$arr_num}:
    0, {/foreach}999
    :
    0
    }
    ;

    var search_fields = {
        {foreach $search_fields as $one_field}'{$one_field.id}': {
            'id': '{$one_field.id}',
            'table_id': '{$one_field.table_id}',
            'name_field': '{$one_field.name_field|replace:'\\':'\\\\'|replace:"'":"\'"}', 'type_field':'{$one_field.type_field}', 'type_value':'{$one_field.type_value_js}', 'default_value':'{$one_field.default_value_js}', 'main':'{$one_field.main}', 'unique':'{$one_field.unique}', 'mult_value':'{$one_field.mult_value}', 'pp':'{$one_field.pp}', 'int_name':'{$one_field.int_name}', 'view':'{$one_field.view}', 'view_tb':'{$one_field.view_tb}', 'view_edit':'{$one_field.view_edit}', 'view_add':'{$one_field.view_add}', 'read':'{$one_field.read}', 'write':'{$one_field.write}', 'child_link_field':'{$one_field.child_link_field}', 'parent_link_field':'{$one_field.parent_link_field}', 's_field_id':'{$one_field.s_field_id}', 's_table_id':'{$one_field.s_table_id}', 's_field_filter_id':'{$one_field.s_field_filter_id}', 'view_html':'{$one_field.view_html}', 'input_value':"{$one_field.input_value}" }, {/foreach} };

            function get_fields_options()
    {
        var fields_options = "";
        for (var id in search_fields) {
            fields_options += "<option value=" + id + ">" + search_fields[id].name_field + "</option>";
        }
        return fields_options;
    }

    function get_term_options(field) {
        var term_options = "";
        if (field) {
            if (field.type_field == 1 || field.type_field == 2 || field.type_field == 8 || field.type_field == 10 || field.type_field == 12)
                term_options = "<option value='='>{$lang['=']}</option><option value='!='>{$lang['!=']}</option><option value='>'>{$lang['>']}</option><option value='<'>{$lang['<']}</option><option value='>='>{$lang['>=']}</option><option value='<='>{$lang['<=']}</option>";
            if (field.type_field == 3 || (field.type_field == 4 && field.mult_value == 1) || (field.type_field == 5 && field.mult_value == 1) || field.type_field == 6 || (field.type_field == 7 && field.mult_value == 1) || field.type_field == 9 || (field.type_field == 14 && field.mult_value == 1) || field.type_field == -1)
                term_options = "<option value='='>{$lang['=']}</option><option value='!='>{$lang['!=']}</option><option value=' like '>{$lang['LIKE']}</option><option value=' not like '>{$lang['NOT LIKE']}</option>";
            if ((field.type_field == 4 && field.mult_value == 0) || (field.type_field == 5 && field.mult_value == 0) || (field.type_field == 7 && field.mult_value == 0) || (field.type_field == 14 && field.mult_value == 0) || field.type_field == 11 || field.type_field == 13)
                term_options = "<option value='='>{$lang['=']}</option><option value='!='>{$lang['!=']}</option>";
        }
        return term_options;
    }

    function get_value_control(rule_id, field, term, num) {
        var control = "";
        if (field) {
            if (field.input_value.substring(0, 7) == "<option")
                control = "<select class='form-control form-control-160' name='set_cond[" + num + "][value]' id='cond_value_" + rule_id + "_" + num + "' onChange='set_date_promt(" + rule_id + ", " + num + "); set_expert(" + rule_id + ");'>" + field.input_value + "</select>";
            else if (field.type_field == 5)
                control = "<select id='cond_value_" + rule_id + "_" + num + "' class='combobox' name='set_cond[" + num + "][value_link]'></select>";
            else
                control = "<input class='form-control form-control-160' type=text name='set_cond[" + num + "][value]' id='cond_value_" + rule_id + "_" + num + "' style='width:120px' onChange='set_expert("+ rule_id + ")'>";
        }
        return control;
    }

    function get_union_options(rule_id, num) {
        var union_options = "";
        union_options = ((num == last_num[rule_id]) ? "<option value=''></option>" : "") + "<option value=' and '>{$lang.and}</option><option value=' or '>{$lang.or}</option>";
        return union_options;
    }

    /**
     * Индексация для автокомплита
     * @type Number
     */
    var global_ac_index = 0;

    function set_search_controls(rule_id, num, cond_field, cond_term, cond_value, cond_value_link, cond_date, cond_oper, cond_interval, cond_period, cond_union, open_bracket, close_bracket) {
        if (!cond_field) cond_field = +$('#cond_field_' + rule_id + '_' + num).val();
        //Для вкладок "Напоминания", "Шаблоны", "Доп. действия", "Подтаблицы" нового правила
        if(search_fields[0] == void 0){
            search_fields[0] = {
                child_link_field: "",
                default_value: "",
                id: "0",
                input_value: "0",
                int_name: "",
                main: "",
                mult_value: "",
                name_field: "",
                parent_link_field: "",
                pp: "",
                read: "",
                s_field_filter_id: "",
                s_field_id: "",
                s_table_id: "",
                table_id: "",
                type_field: "",
                type_value: "",
                unique: "",
                view: "",
                view_add: "",
                view_edit: "",
                view_html: "",
                view_tb: "",
                write: "",
            }
        }
        field = search_fields[cond_field];
        const fieldType = parseInt(field.type_field);
        const fieldMultVal = parseInt(field.mult_value);
        const termFocused =  $('#cond_term_' + rule_id + '_' + num).is(':focus');
        const condFocused =  $('#cond_field_' + rule_id + '_' + num).is(':focus');

        if (field) {
            $('#cond_field_' + rule_id + '_' + num).html(get_fields_options());
            $('#cond_field_' + rule_id + '_' + num).val(cond_field);
            $('#cond_term_' + rule_id + '_' + num).html(get_term_options(field));
            $('#cond_term_' + rule_id + '_' + num).val(cond_term ? (termFocused ? cond_term : (fieldMultVal === 1 ? (condFocused ? ' like ' : cond_term) : cond_term)) : (fieldMultVal === 1 ? ' like ' : '='));
            $('#span_cond_value_' + rule_id + '_' + num).html(get_value_control(rule_id, field, cond_term, num));

            const condTermVal = $('#cond_term_' + rule_id + '_' + num).val();
            if (condTermVal === '=') checkFieldForMultiValAndShowTooltip(fieldType, fieldMultVal, 1);
            if (condTermVal === '!=') checkFieldForMultiValAndShowTooltip(fieldType, fieldMultVal, 2);

            if (fieldType == 5) {
                create_ac_by_cond('#cond_value_' + rule_id + '_' + num, global_ac_index, cond_value_link, cond_field, '{$table_id}', '{$filter_id}', set_expert(rule_id));
                global_ac_index++;
            }
            if (fieldType == 2 || fieldType == 12) {
                $('#date_interval_' + rule_id + '_' + num).css("display", "");
            } else {
                $('#date_interval_' + rule_id + '_' + num).css("display", "none");
            }
            if ((fieldType == 2 || fieldType == 12) && cond_value == 'fix_date') {
                $('#date_value_' + rule_id + '_' + num).css("display", "");
            } else {
                $('#date_value_' + rule_id + '_' + num).css("display", "none");
            }
            if ((fieldType == 2 || fieldType == 12) && !cond_value) {
                $('#cond_value_' + rule_id + '_' + num).val("0000-00-00 00:00:00");
            } else if (fieldType == 13 && !cond_value) {
                $('#cond_value_' + rule_id + '_' + num).val(0);
            } else {
                if(fieldType == 5 && cond_value == null){
                    $('#cond_value_' + rule_id + '_' + num).val('0');
                }
                else {
                    $('#cond_value_' + rule_id + '_' + num).val(cond_value);
                }

            }
            $('#cond_oper_' + rule_id + '_' + num).html("<option value=''></option><option value=' + interval '>+</option><option value=' - interval '>-</option>");
            $('#cond_period_' + rule_id + '_' + num).html("<option value=''></option><option value=' day'>" + lang.days + "</option><option value=' month'>" + lang.months + "</option><option value=' year'>" + lang.years + "</option><option value=' hour'>" + lang.hours + "</option><option value=' minute'>" + lang.minutes + "</option>");
            $('#cond_date_' + rule_id + '_' + num).val(cond_date);
            $('#cond_oper_' + rule_id + '_' + num).val(cond_oper);
            $('#cond_interval_' + rule_id + '_' + num).val(cond_interval);
            $('#cond_period_' + rule_id + '_' + num).val(cond_period);
            $('#cond_union_' + rule_id + '_' + num).html(get_union_options(rule_id, num));
            $('#cond_union_' + rule_id + '_' + num).val(cond_union);
            $('#cond_ob_' + num).val(+open_bracket ? 1 : 0);
            $('#cond_cb_' + num).val(+close_bracket ? 1 : 0);
            $('#span_ob_' + num).css('color', +open_bracket ? 'black' : '#ddd');
            $('#span_cb_' + num).css('color', +close_bracket ? 'black' : '#ddd');
            $('#span_ob_' + num).prop('title', +open_bracket ? lang.Disable_bracket: lang.Enable_bracket);
            $('#span_cb_' + num).prop('title', +open_bracket ? lang.Disable_bracket: lang.Enable_bracket);
            set_date_promt(rule_id, num);
            set_expert(rule_id);
        }

        init_chosen();
    }

    function add_cond(rule_id, num, cond_field, cond_term, cond_value, cond_value_link, cond_date, cond_oper, cond_interval, cond_period, cond_union, open_bracket, close_bracket) {
        last_num[rule_id] = num;
        var new_cond = "<div id='cond_" + rule_id + "_" + num +
                       "' style='padding:2px;display:flex;align-items:center;'><img alt='{$lang.delete}' title='{$lang.Delete_condition}' " +
                       "src='images/b_drop.png' border=0 style='cursor:pointer; vertical-align:middle; padding-bottom:3px' onclick='del_cond(" +
                       rule_id + ", " + num + ")'> <span id='span_ob_" + num +
                       "' class='brackets' style='cursor:pointer' onclick='set_bracket(\"ob_" + num + "\"); set_expert(" + rule_id +
                       ");'><b>(</b></span> <input type='hidden' name='set_cond[" + num + "][open_bracket]' id='cond_ob_" + num +
                       "'> <span><select class='form-control form-control-160' name='set_cond[" + num + "][field]' id='cond_field_" + rule_id + "_" + num +
                       "' onChange='set_search_controls(" + rule_id + ", " + num + "); set_expert(" + rule_id +
                       ");'></select></span><span> <select class='form-control form-control-160' name='set_cond[" + num + "][term]' id='cond_term_" +
                       rule_id + "_" + num + "' style='width:150px' onChange='set_date_promt(" + rule_id + ", " + num + "); set_expert(" + rule_id +
                       ");'></select></span> <span id='span_cond_value_" + rule_id + "_" + num +
                       "' style='display: inline-block;'><input class='form-control form-control-160' type=text id='cond_value_" + rule_id + "_" + num +
                       "'></span> <span id='date_value_" + rule_id + "_" + num + "'><input class='form-control dtpicker' type=text name='set_cond[" + num + "][date]' id='cond_date_" + rule_id + "_" + num 
                       + "' onchange='set_date_promt(" + rule_id + "_" + num + "); set_expert();'></span> <span id='date_interval_" + rule_id + "_" + num + 
                       "'><span><select class='form-control form-control-160' name='set_cond[" + num +
                       "][oper]' id='cond_oper_" + rule_id + "_" + num + "' onChange='set_date_promt(" + rule_id + ", " + num + "); set_expert(" + rule_id +
                       ");'></select></span> <input class='form-control form-control-160' type=text name='set_cond[" + num + "][interval]' id='cond_interval_" + rule_id +
                       "_" + num + "' style='text-align:right; width:30px;' onChange='set_date_promt(" + rule_id + ", " + num + "); set_expert(" + rule_id +
                       ");'> <span><select class='form-control form-control-160' name='set_cond[" + num + "][period]' id='cond_period_" + rule_id + "_" + num +
                       "' onChange='set_date_promt(" + rule_id + ", " + num + "); set_expert(" + rule_id + ");'></select></span></span> <span id='span_cb_" + num +
                       "' class='brackets' style='cursor:pointer' onclick='set_bracket(\"cb_" + num + "\"); set_expert(" + rule_id +
                       ");'><b>)</b></span> <input type='hidden' name='set_cond[" + num + "][close_bracket]' id='cond_cb_" + num +
                       "'> <span><select class='form-control form-control-75' name='set_cond[" + num + "][union]' id='cond_union_" + rule_id + "_" + num +
                       "' onChange='if (last_num[" + rule_id + "]==" + num + ") add_cond(" + rule_id + "," + (num + 1) + "); set_expert(" + rule_id +
                       ");'></select></span> &nbsp; <span id='date_promt_" + rule_id + "_" + num + "' style='color:gray'></span></div>";
        if (num == 1) {
            $("#wizard_set" + rule_id).html(new_cond);
        }
        else {
            prev_cond_union = $('#cond_union_' + rule_id + '_' + (num - 1)).val();
            $('#cond_union_' + rule_id + '_' + (num - 1)).html(get_union_options(rule_id, (num - 1)));
            $('#cond_union_' + rule_id + '_' + (num - 1)).val(prev_cond_union);
            $("#cond_" + rule_id + '_' + (num - 1)).after(new_cond);
        }
        set_search_controls(rule_id, num, cond_field, cond_term, cond_value, cond_value_link, cond_date, cond_oper, cond_interval, cond_period, cond_union, open_bracket, close_bracket)
    }

    function set_bracket(id) {
        var bracket = ($('#cond_' + id).val() == '1') ? 0 : 1;
        $('#cond_' + id).val(bracket);
        $('#span_' + id).css('color', bracket ? 'black' : '#ddd');
        $('#span_' + id).prop('title', bracket ? lang.Disable_bracket: lang.Enable_bracket);
    }

    function setDefaultBrackets() {
        $('.brackets').each( (i,item) => {
            item = $(item);
            if ( item.next().val() == 0 || item.next().val() == '' ) {
                item.css('color', '#ddd').prop('title', lang.Enable_bracket);
            } else {
                item.css('color', 'black').prop('title', lang.Disable_bracket);
            }
        });
    }

    function del_cond(rule_id, num) {
        $('#cond_' + rule_id + '_' + num).remove();
        if (num == last_num[rule_id]) {
            for (var i = num - 1; i > 0; i--) {
                if (document.getElementById('cond_' + rule_id + '_' + i)) {
                    last_num[rule_id] = i;
                    $('#cond_union_' + rule_id + '_' + i).html(get_union_options(rule_id, i));
                    break;
                }
            }
        }
        if (!$('#wizard_set' + rule_id).html()) add_cond(rule_id, 1);
        set_expert(rule_id);
    }

    function set_expert(rule_id) {
        var condition = "";
        var and_count = 0;
        var or_count = 0;
        for (var num = 1; num <= last_num[rule_id]; num++) {
            if (document.getElementById('cond_' + rule_id + '_' + num) && $('#cond_field_' + rule_id + '_' + num).val() == '-1') {
                condition += "{ldelim}new_record{rdelim}" + $('#cond_union_' + rule_id + '_' + num).val();
            }
            if (document.getElementById('cond_' + rule_id + '_' + num) && ($('#cond_field_' + rule_id + '_' + num).val() > '0' || $('#cond_field_' + rule_id + '_' + num).val() == '-2')) {
                var cond_union = $('#cond_union_' + rule_id + '_' + num).val();

                and_count += (cond_union == ' and ') ? 1 : 0;
                or_count  += (cond_union == ' or ' ) ? 1 : 0;
            }
        }
        if (and_count == 0 || or_count == 0) {
            $('.brackets').css('visibility', 'hidden');
        } else {
            $('.brackets').css('visibility', 'visible');
        }
        setDefaultBrackets();
    }

    function check_brackets(rule_id) {
        var open_brackets = 0;
        var close_brackets = 0;
        for (var num = 1; num <= last_num[rule_id]; num++) {
            if (document.getElementById('cond_' + num) && $('#cond_field_' + num).val() != 0 && !$('#cond_field_' + num).prop("disabled")) {
                open_brackets += +$('#cond_ob_' + num).val();
                close_brackets += +$('#cond_cb_' + num).val();
                if (close_brackets && !open_brackets) break;
            }
        }
        if (open_brackets != close_brackets) {
            return false;
        } else {
            return true;
        }
    }

    $(function () {
        {foreach from=$set_cond_array item=set_cond key=arr_num}
        {foreach from=$set_cond item=cond key=num}
        add_cond({$arr_num},{$num}, {$cond.field}, '{$cond.term}', '{$cond.value|replace:"'":"\'"}', '{$cond.value_link}', '{$cond.date}', '{$cond.oper}', '{$cond.interval}', '{$cond.period}', '{$cond.union}', '{$cond.open_bracket}', '{$cond.close_bracket}');
        {/foreach}
        {foreachelse}
        add_cond(999, 1);
        {/foreach}
        setDefaultBrackets();
    });
</script>
