import {ITable, ITableFiles, ITableLine} from './table';
import View from '../view';
import {getUrlVars, TypeFields} from '../util';
import Access from '../access';

const drawTable = (data: ITable): string => {
    let headRow: string = ``;
    data.row_header.forEach((value: string) => {
         headRow += `<div class="cb-table__cell cb-table__cell--head">${value}</div>`;
    });
    let rows: string = ``;
    for (const id in data.lines) {
        const row: Array<ITableLine> = data.lines[id];
        let cells: string = ``;
        row.forEach((value: ITableLine) => {
            if(value == null) return;
            let _value: string = ``;
            if (typeof value.display_value === `object`) {
                if (value.type == TypeFields.IMAGE) {
                    value.display_value.forEach((file: ITableFiles) => {
                        _value += `<img src="${file.src}" alt="${file.name}">`;
                    });
                } else if (value.type == TypeFields.FILE) {
                    value.display_value.forEach((file: ITableFiles) => {
                        _value += `<a href="${file.src}" download>${file.name}</a>`;
                    });
                }
            } else {
                _value = value.display_value;
            }
            cells += `<div class="cb-table__cell">${_value}</div>`;
        });
        rows += `<div class="cb-table__row cb-table__row--simple" row-id="${id}">${cells}</div>`;
    }
    let pags: string = `<div class="cb-pagination">`;
    const currentPag: number = parseInt(getUrlVars()[`pagination`]) || 0;
    for (let i = 0; i < data.paginations; i++) {
        const disabled: string = (currentPag === i) ? `disabled` : ``;
        pags += `<button type="button" index="${i}" class="cb-pagination__btn" ${disabled}>${i + 1}</button>`;
    }
    pags += `</div>`;
    const addBlock: string = (Access.add === 1) ? `<div class="cb-add-wrap">
        <button id="add-line" class="nav-bar__btn nav-bar__btn--add">Добавить запись</button>
    </div>` : `<div class="empty"></div>`;
    const searchWrap: string = (Access.search === 1) ? `<div class="cb-search">
        <input type="text" class="cb-search__input" id="search-input">
        <button type="button" class="cb-search__submit" id="search-submit">Найти</button>
    </div>`: `<div class="empty"></div>`;

    return `<div class="cb-table-head">
    ${addBlock}
    ${searchWrap}
</div>
${pags}
<div class="cb-wrap" id="inner">
    <div class="cb-table-head" id="cb-table-head"></div>
    <div class="cb-table-wrap" id="cb-table-wrap">
        <div class="cb-table__row cb-table__row--head">${headRow}</div>
        ${rows}
    </div>
    <div class="cb-table-footer" id="cb-table-footer"></div>
</div>
<div class="cb-table-footer">${pags}</div>`;
};

export default class TableView extends View {
    constructor(data: ITable) {
        super(data);
    }

    protected get template(): string {
        return drawTable(this.data);
    }
}
