/**
 * Функции для модуля IP-телефонии Asterisk
 * Created: 15.07.2014
 * Created by: Andrey
 * Edit by: Ruslan J.
 * Copyright: Clientbase (www.clientbase.ru)
 */

var open_key = '';
var main_server = '';
var asterisk_server = '';
var asterisk_number = '';
var asterisk_password = '';
var asterisk_city_code = '';
var asterisk_ban_code = '';
var asterisk_client_host = '';
var asterisk_loc_num_length = 0;
var asterisk_call_status = 0;
var asterisk_timeout_main_old = 5000;
var asterisk_timeout_main_new = 1000;
var asterisk_timeout = 1000;

var prev_sec = -1;
function time() {
    if (prev_sec < 0) return;

    var sec_ = prev_sec % 60;
    var min_ = intval(prev_sec / 60);
    var hours_ = '00';

    var zeros = '';
    if (sec_ < 10) zeros = '0';
    var zerom = '';
    if (min_ < 10) zerom = '0';

    var pos = document.getElementById("asterisk_time");
    if (pos) pos.innerHTML = hours_ + ':' + zerom + min_ + ':' + zeros + sec_;

    prev_sec++;
}

$(function () {
    setInterval(function () {
        time();
    }, asterisk_timeout);
});

function module_asterisk_extension(direction) {
    if (direction == 'incoming') session = incomingSession;
    if (direction == 'outgoing') session = outgoingSession;
    session.dtmf($('#extens_number').val(), {interToneGap: 200});
    $('#extens_block').hide();
    $('#phone_buttons').show();
}

function module_asterisk_transfer(direction) {
    if (direction == 'incoming') session = incomingSession;
    if (direction == 'outgoing') session = outgoingSession;
    session.dtmf('#'+$('#transfer_number').val(), {interToneGap: 200});
    $('#transfer_block').hide();
    $('#asterisk_time_in').text(lang['Transfer_call'] + '...');
}

var asterisk_hold = false;
function module_asterisk_hold(direction) {
    if (direction == 'incoming') session = incomingSession;
    if (direction == 'outgoing') session = outgoingSession;
    if (!asterisk_hold) {
        session.hold();
        $('#hold_button').css('background-color', 'orange');
        $('#hold_button').html(lang['Hold'] + '...');
    } else {
        session.unhold();
        $('#hold_button').css('background-color', 'lightgray');
        $('#hold_button').html(lang['Hold']);
    }
    asterisk_hold = !asterisk_hold;
}

function module_asterisk_status() {
    $.ajax({
        type: "POST",
        url: asterisk_client_host ? "modules/asterisk/asterisk_status.php" : "modules/asterisk/asterisk_functions.php",
        data: {
            opt: 'status',
            action: 'status',
            login: asterisk_number,
            data: {
                key: open_key,
                master: main_server,
                login: asterisk_number,
                password: asterisk_password,
                action: 'status'
            },
            csrf: csrf
        },
        success: function (msg) {
            if (msg) {
                p_msg = explode('@@', msg);
                if (p_msg[2] == 'incoming' || p_msg[2] == 'outgoing') {
                    if (p_msg[1] && !p_msg[3] && prev_sec == -1) {
                        cbNotifyObject.closeEventTooltip(999, 'asterisk');
                        var eMsg = '<br/><br/><span>' + lang['Time'] + ': </span><span id="asterisk_time">00:00:00</span><br/><br/><span id="asterisk_time_in"></span>';
                        asterisk_window(lang['Status_conversation'], eMsg, 997);
                        prev_sec = p_msg[1];
                    }
                    else if (p_msg[3] && prev_sec != -1) {
                        $('#asterisk_time_in').text(lang['Conversation_ended']);
                        closeTipTimeout(997);
                        prev_sec = -1;
                    }
                }
                else if (p_msg[0]) {
                    if (p_msg[0] == 'outgoing_process') {
                        var phone = p_msg[1];
                        var direction = 'outgoing';
                    } else {
                        var phone = p_msg[0];
                        var direction = 'incoming';
                    }
                    $.ajax({
                        type: "POST",
                        url: "modules/asterisk/asterisk_functions.php",
                        data: {sel: 'open', type: 'client', phone: phone, csrf: csrf},
                        success: function (msg) {
                            if (msg) {
                                asterisk_window_connecting(phone, msg, direction);
                            }
                        }
                    });
                }
                else {
                    cbNotifyObject.closeEventTooltip(999, 'asterisk');
                }
            }
        }
    });
}

function closeTipTimeout(eId, time) {
    if (!time) time = 10000;
    setTimeout(function () {
        cbNotifyObject.closeEventTooltip(eId, 'asterisk');
        if ($('.user_sub_table object').length > 0) {
            location.reload();
        }
    }, time);
}

// Исходящий вызов
function module_asterisk_call(phone, table_id, line_id, sip_id) {

    var temp = phone.split(',');
    phone = temp[0];
    var disp_phone = phone;
    if (phone.substring(0, 1) == '|') {
        temp = phone.split('|');
        num_phone = temp[1];
        disp_phone = temp[2];
        $.ajax({
            async: false,
            type: "POST",
            url: "modules/asterisk/asterisk_functions.php",
            data: {sel: 'open', type: 'phone', table_id: table_id, line_id: line_id, num_phone: num_phone, csrf: csrf},
            success: function (msg) {
                if (msg) {
                    phone = msg;
                }
            }
        });
    }
    if (phone.replace(/\s/g, '').substring(0, 1) == '+') {
        var prefix = '+';
    } else {
        var prefix = '';
    }
    phone = phone.replace(/\D/g, '');
    if (phone.length < 11 && phone.length > 3 && asterisk_city_code) {
        var tphone = asterisk_city_code + phone;
    } else {
        var tphone = phone;
    }
    if (tphone.length < 11 && tphone.length > 3 && tphone.length != asterisk_loc_num_length) {
        var alr_msg = lang['Bad_number'];
        if (asterisk_loc_num_length) {
            alr_msg += lang['or'] + lang['from'] + asterisk_loc_num_length + lang['Digits_local_calls'];
        }
        jalert(alr_msg + '.');
        return false;
    }
    if (asterisk_ban_code && tphone.length > 3) {
        var temp = asterisk_ban_code.split(',');
        for (k in temp) {
            if (tphone.indexOf(temp[k].replace(/\D/g, '')) === 0) {
                jalert(lang['Disabled_call']);
                return false;
            }
        }
    }
    phone = prefix + phone;

    $.ajax({
        type: "POST",
        url: "modules/asterisk/asterisk_functions.php",
        data: {
            opt: 'call',
            data: {
                key: open_key,
                master: main_server,
                login: asterisk_number,
                password: asterisk_password,
                action: 'call',
                sip: sip_id,
                value: sip_id ? sip_id + '#' + phone : phone
            },
            sel: 'open',
            type: 'client',
            phone: phone,
            table_id: table_id,
            line_id: line_id,
            csrf: csrf
        },
        success: function (msg) {
           if(msg === 'trial') {
                jalert(lang.asterisk_trial);
                return false;
            }
            if (msg) {
                asterisk_window_connecting(disp_phone, msg, 'outgoing');
            }

            // Звонок выполняется в браузерном SIP-клиенте
            if (user.browser_caller) {
                txtPhoneNumber = sip_id ? sip_id + '#' + phone : phone;
                startJsCall(txtPhoneNumber);
            }
        }
    });
}
function module_asterisk_call_window(phone, table_id, line_id, sip_id) {
    phone_window = window.open('', 'phone_window');
    if (phone_window.location.href == 'about:blank') { // окно не найдено, пытаемся открыть заново
        phone_window = window.open('phone.php', 'phone_window');
        if (!phone_window)
            alert(lang['Disabled_pop_ups']);
        else
            $.cookie('outgoing_call', [phone, table_id, line_id, sip_id]); // передаем данные в окно для звонка после загрузки
    }
    else if (phone_window.asterisk_ban_code != asterisk_ban_code || phone_window.asterisk_city_code != asterisk_city_code) { // окно найдено, но изменились настройки телефонии, перезагружаем окно
        $.cookie('phoneWindowReload', 1);
        phone_window.location.reload();
        $.cookie('outgoing_call', [phone, table_id, line_id, sip_id]); // передаем данные в окно для звонка после загрузки
    }
    else { // окно уже открыто
        phone_window.module_asterisk_call(phone, table_id, line_id, sip_id); // запускаем звонок сразу
    }
}

// Сбросить
function module_asterisk_break(call_id) {
    if (!call_id) call_id = 999;
    cbNotifyObject.closeEventTooltip(call_id, 'asterisk');

    if (user.browser_caller) {
        endJsCall();
    }

    $.ajax({
        type: "POST",
        url: "modules/asterisk/asterisk_functions.php",
        data: {
            opt: 'hangup',
            data: {
                key: open_key,
                master: main_server,
                login: asterisk_number,
                password: asterisk_password,
                action: 'hangup'
            },
            csrf: csrf
        }
    });
}

// Всплывающие окна
function asterisk_window(title, text, eId) {
    old = user.cut_notify_text;
    user.cut_notify_text = 0;

    var eMsg = "<b style='color: #D48787'>" + title + "</b> " + text;
    if (!eId) eId = 0;
    cbNotifyObject.newEventBubble('asterisk', eId, eMsg, "#505050", "#ffffff");
    $('.event_content').css('cursor', 'default');

    user.cut_notify_text = old;
}

function asterisk_window_connecting(phone, msg, direction) {
    p_msg = explode('@@', msg);
    var from_name = trim(p_msg[1]);
    if (from_name == 'NULL_NAME') from_name = '';
    var from_url = trim(p_msg[2]);
    var addit_1 = '', addit_2 = '', addit_3 = '';
    if (p_msg[3]) addit_1 = '<br/>' + trim(p_msg[3]);
    if (p_msg[4]) addit_2 = '<br/>' + trim(p_msg[4]);
    if (p_msg[5]) addit_3 = '<br/>' + trim(p_msg[5]);

    var cart_name = "<br/>" + lang['Card'] + ": ";
    if (from_name) {
        cart_name += "<a href='" + from_url + "' class='call_window_link'" + (user.browser_caller ? " target='_blank'" : "") + "><b>" + from_name + "</b></a>";
    } else {
        cart_name += "<a href='" + from_url + "' class='call_window_link'" + (user.browser_caller ? " target='_blank'" : "") + "><b>" + lang['create'] + "</b></a>";
    }
    cart_name += addit_1 + addit_2 + addit_3 + '<br/><br/>';

    if (direction == "incoming") {
        title = lang['Incoming_call'] + ":";
        dir_num = lang['From_number'] + ": ";
    }
    if (direction == "outgoing") {
        title = lang['Outgoing_call'] + ":";
        dir_num = lang['To_number'] + ": ";
    }

    phone = buildPhoneNumber(phone);

    var eMsg = "<br/><br/>" + dir_num + phone + cart_name;
    if (direction == "incoming" && user.browser_caller) eMsg += "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid;' onclick=\"answerJsCall(); event.cancelBubble = true\" id=\"buttonAnswerCall\">" + lang['To_accept'] +"</button>";
    if (user.browser_caller) eMsg += "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid;float: right;' onclick='module_asterisk_break();'>" + lang['Reset'] + "</button><br/><br/>";

    asterisk_window(title, eMsg, 999);
}

// сформировать номер телефона
function buildPhoneNumber(phone) {
  /* Как скрывать телефоны:
    - полностью = -1
    - заменять звездочками = 0
    - X первых символов = 1
    - X последних символов = 2
  */
  const hide_phones_type = ASTERISK_SETTINGS.hide_phones_type || -1;
  // Скрывать телефоны для групп доступа
  const hide_phones_for_groups = (ASTERISK_SETTINGS.hide_phones_for_groups || "").split(',');

  // для текущей группы не скрыто
  if (!hide_phones_for_groups.includes((user?.group_id || 0))) {
    return phone;
  }

  if (!phone) {
    return lang['Hidden'];
  }

  switch (hide_phones_type) {
    case '-1': // полностью
    case '0': // заменять звездочками
    case '1': // X первых символов
    case '2': // X последних символов
    default: return lang['Hidden'];
  }
}

function asterisk_window_active(direction) {
    cbNotifyObject.closeEventTooltip(999, 'asterisk');
    prev_sec = 0;
    var eMsg = "<br/><br/><span>" + lang['Time'] + ": </span><span id='asterisk_time'>00:00:00</span><br/><br/><span id='asterisk_time_in'></span>" +
            "<div id='phone_buttons'>" +
            "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid; width:100px; margin:2px;' onclick=\"$('#phone_buttons').hide(); $('#extens_block').show(); $('#extens_number').focus();\">" + lang['Extend_c'] +"</button>" +
            "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid; width:100px; margin:2px;' onclick=\"$('#phone_buttons').hide(); $('#transfer_block').show(); $('#transfer_number').focus();\">" + lang['Transfer_c'] +"</button><br>" +
            "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid; width:100px; margin:2px;' onclick=\"module_asterisk_hold('" + direction + "')\">" + lang['Hold'] +"</button>" +
            "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid; width:100px; margin:2px;' onclick='endJsCall()'><img src='images/phone_red.png' style='padding-bottom:1px;'> " + lang['Reset'] +"</button></div>" +
            "<div id='extens_block' style='display:none'>" + lang['Extend_c'] +": &nbsp;" +
            "<input type='text' id='extens_number' style='width:60px; color:black;' onkeyup=\"if ((event.keyCode == 0xA)||(event.keyCode == 0xD)) module_asterisk_extension('" + direction + "')\"> &nbsp;" +
            "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid;' onclick=\"module_asterisk_extension('" + direction + "')\">OK</button> &nbsp;" +
            "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid;' onclick=\"$('#extens_block').hide(); $('#phone_buttons').show();\">" + lang['Cancel'] +"</button></div>" +
            "<div id='transfer_block' style='display:none'>" + lang['Transfer_c'] +": &nbsp;" +
            "<input type='text' id='transfer_number' style='width:60px; color:black;' onkeyup=\"if ((event.keyCode == 0xA)||(event.keyCode == 0xD)) module_asterisk_transfer('" + direction + "')\"> &nbsp;" +
            "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid;' onclick=\"module_asterisk_transfer('" + direction + "')\">OK</button> &nbsp;" +
            "<button style='cursor: pointer;color: black;background-color: lightgray;padding: 0 5px;border: gray 1px solid;' onclick=\"$('#transfer_block').hide(); $('#phone_buttons').show();\">" + lang['Cancel'] +"</button></div>";
    asterisk_window(lang['Status_conversation'], eMsg, 997);
}
function asterisk_window_ended() {
    if (document.getElementById("new_event_bubbleasterisk997")) {
        $('#asterisk_time_in').text(lang['Conversation_ended']);
        document.getElementById("phone_buttons").style.display = "none";
        document.getElementById("extens_block").style.display = "none";
        document.getElementById("transfer_block").style.display = "none";
        closeTipTimeout(997);
        prev_sec = -1;
    }
}
