//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [

    {
        //Вкладка "Подключения"
        header: 'apps',

        forms: [

            {

                header: "apps_header",

                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "apps",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_app",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],

                //Форма добавления/редактирования может быть задана через formBlocks, formLines, fields
                //Для краткости примера создаем через fields
                fields: ['name', 'auth_token'],

                archive: {
                    field: "arc",
                    on: 1,
                    off: 0
                },

                activity:  {
                    field: "disabled",
                    on: 0,
                    off: 1
                },

                delete: {
                    confirm: "delete_app",
                    linked: [
                        {
                            list: "connectors",
                            field: "external_app_id",
                        }
                    ]
                },                

                copy: true

            }

        ]

    },

    {
        //Вкладка "Таблицы"
        header: 'tables',

        forms: [

            {

                showOn: 'apps',

                header: "prepare_tables",
                
                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "tables",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_table",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],


                formBlocks: [
                    { //Общие настройки таблицы
                        fields: ['name', 'external_object_type', 'internal_object_id'],
                        //Маппинг ID
                        custom: {
                            'integration-id-mapping': {
                                apps: "apps",
                                table: "internal_object_id",
                                field: "internal_connect_fields",
                                help: "afisharu_id_mapping"
                            }
                        }                        
                    },
                    {
                        header: 'fields_mapping',
                        custom: {
                            'integration-fields-mapping': {
                                app_object: "external_object_type",
                                table: "internal_object_id",
                                help: "help_afisharu",
                                help_unique: true
                            }
                        }
                    }
                ],

                archive: {
                    field: "arc",
                    on: "1",
                    off: "0"
                }                

            },  

            {
                hideOn: 'apps',
                saveButton: false,

                formBlocks: [
                    {
                        message: {
                            template: "Начните настройку модуля с создания подключения",
                            status: "alert"
                        }
                    }
                ]
            }


        ]        

    },    

    {
        //Вкладка "Интеграции"
        header: 'connectors',

        forms: [

            {

                showOn: 'apps',

                header: "connectors",
                
                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "connectors",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_connector",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],


                formBlocks: [
                    { //Общие настройки интеграции
                        fields: ['name', 'external_app_id', 'internal_action']
                    },
                    {
                     //Настройки вызова команда
                        header: 'connector_command_settings',       
                        fields: ['object_mapping_id', 'external_action'],
                        custom: {
                            'integration-fields-mapping': {
                                prefix: "external_action_params_",
                                fieldsList: "params",
                                fieldsType: true,
                                app_object: "external_object_type",
                                app_action: "external_action",
                                table: "internal_object_id",
                                from_list: "tables",
                                from_list_value: "object_mapping_id",
                                help: "help_afisharu",
                                help_unique: true
                            }
                        }                                        
                    },
/*                    
                    { //Настройки интеграции вызова команды
                        showOn: 'type',
                        showOnValue: 'out',
                        header: 'connector_out_settings',
                        fields: ['external_object_type', 'external_action', 'internal_object_id', 'action_event', 'internal_action']
                    },
                    { //Настройки интеграции вебхука
                        showOn: 'type',
                        showOnValue: 'in',
                        header: 'connector_in_settings',
                        fields: ['external_object_type', 'external_hook_action', 'internal_object_id', 'internal_hook_action']                        
                    },
                    { //Настройки синхронизации
                        showOn: 'type',
                        showOnValue: 'sync',
                        header: 'connector_sync_settings',
                        fields: ['external_object_type', 'internal_object_id', 'external_add_records', 'external_delete_records', 'internal_add_records', 'internal_delete_records']
                    },   
                    { //Поле связи
                        formLines: [
                            {
                                label: 'internal_connect_field',
                                fields: ['internal_connect_field']
                            },
                            {
                                showOn: 'internal_connect_field',
                                showOnValue: '1',
                                label: 'internal_connect_field_name',
                                fields: ['internal_connect_field_name']
                            },
                            {
                                showOn: 'internal_connect_field',
                                showOnValue: '2',
                                label: 'internal_connect_field_id',
                                fields: ['internal_connect_field_id']
                            }
                        ]
                    },
*/                    
                    
                    {
                        showOn: 'object_mapping_id',
                        header: 'fields_mapping',
                        custom: {
                            'integration-fields-mapping': {
                                app_object: "external_object_type",
                                app_action: "external_action",
                                table: "internal_object_id",
                                from_list: "tables",
                                from_list_value: "object_mapping_id",
                                help: "help_afisharu",
                                help_unique: true
                            }
                        }
                        
                    },

                    {
                        hideOn: 'cron_id',
                        header: 'calc_conditions',
                        custom: {
                            'calc-conditions': {
                                fieldCond: "calc_cond",
                                fieldPeriod: "cron_period",
                                table: "internal_object_id",
                                from_list: "tables",
                                from_list_value: "object_mapping_id",
                                label: 'calc_conditions',
                                help: "afisharu_run_conditions"                         
                            }
                        }
                        //fields: ['calc_id'],
                    },                    

                    {
                        showOn: 'calc_id',
                        hideOn: 'calc_id',
                        hideOnValue: 'deleted',
                        fields: ['calc']
                    },

                    {
                        showOn: 'cron_id',
                        hideOn: 'cron_id',
                        hideOnValue: 'deleted',                        
                        fields: ['cron']
                    },


                ],

                archive: {
                    field: "arc",
                    on: "1",
                    off: "0"
                },
                
                activity:  {
                    field: "disabled",
                    on: 0,
                    off: 1
                },

                //copy: true,

                alert: {
                    field: "__error"
                }                

            },  

            {
                hideOn: 'apps',
                saveButton: false,

                formBlocks: [
                    {
                        message: {
                            template: "Начните настройку модуля с создания подключения",
                            status: "alert"
                        }
                    }
                ]
            }            


        ]

    },
/*
    {
        //Вкладка "Дополнительно"
        header: 'misc'
    }
*/

];

export default composition;