//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [

    {
        //Вкладка "Подключения"
        header: 'apps',

        forms: [

            {

                header: "apps_header",

                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "apps",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_app",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],

                formBlocks: [
                    {
                        fields: ['name', 'auth_client_id', 'auth_crt_p12', 'auth_crt_password', 'auth_client_secret', 'auth_client_secret_expires', 'auth_client_secret_autoupdate']
                    },

                    {
                        showOn: '__oauth_button',
                        fields: ['__oauth_button']
                    },

                    {
                        showOn: '__token_expires',
                        fields: ['__token_expires']
                    },                    
                    
                ],

                alert: {
                    field: "__error"
                },
                
                delete: {
                    confirm: "delete_app",
                    linked: [
                        {
                            list: "connectors",
                            field: "external_app_id",
                        }
                    ]
                }                 

            },

            {
                formBlocks: [
                    {
                        "message": {
                            "template": "<br/><br/>Модуль использует дополнение \"Интернет-банк\".<br/>Убедитесь, что дополнение установлено и корректно работает: <a href=\"edit_transfer.php\" target=\"_blank\">настройка дополнений</a>"
                        }
                    }
                ],

                saveButton: false,

            }

        ]

    },

    {
        //Вкладка "Таблицы"
        header: 'tables',

        forms: [

            {

                showOn: 'apps',

                header: "prepare_tables",

                data: "table",

                field: "tables",

                formBlocks: [
                    { //Общие настройки таблицы
                        fields: ['internal_object_id'],
                        //Маппинг ID
                        custom: {
                            'integration-id-mapping': {
                                apps: "apps",
                                table: "internal_object_id",
                                field: "internal_connect_fields",
                                help: "bank_id_mapping"
                            }
                        }                          
                    },
                    {
                        header: 'fields_mapping',
                        custom: {
                            'integration-fields-mapping': {
                                app_object: "external_object_type",
                                table: "internal_object_id",
                                help: "help_bank_sber",
                                help_unique: true
                            }
                        }
                    }
                ],

            },  

            {
                hideOn: 'apps',
                saveButton: false,

                formBlocks: [
                    {
                        message: {
                            template: "Начните настройку модуля с создания подключения",
                            status: "alert"
                        }
                    }
                ]
            }             

        ]        

    },    

    {
        //Вкладка "Интеграции"
        header: 'connectors',

        forms: [

            {

                showOn: 'apps',

                header: "connectors",
                
                //listForm=true - форма со списком, управляет массивом настроек
                listForm: true,

                //field: поле, содержащее массив настроек
                field: "connectors",

                //addButton: текст ссылки добавления нового элемента
                addButton: "add_connector",

                //listFields - поля, которые будут выведены в списке
                listFields: ['name'],


                formBlocks: [
                    { //Настройки интеграции
                        fields: ['name', 'external_app_id', 'external_action_params_accountNumber'] 
                    }, 

                    {
                        hideOn: "cron_id",
                        fields: ['cron_id_period']
                    },

                    {
                        showOn: "cron_id",
                        fields: ['cron']
                    }

                ],

                activity:  {
                    field: "disabled",
                    on: 0,
                    off: 1
                },

                alert: {
                    field: "__error"
                }                

            },  

            {
                hideOn: 'apps',
                saveButton: false,

                formBlocks: [
                    {
                        message: {
                            template: "Начните настройку модуля с создания подключения",
                            status: "alert"
                        }
                    }
                ]
            }            


        ]

    }

];

export default composition;