//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [

    {
        header: "main_settings",
        noticeFromStore: "enable_fast_edit",
        forms: [

            {
                formBlocks: [
                    {
                        formLines: [
                            {
                                label: "api_connection_type",
                                fields: ['api_connection_type'],
                                help: "google-api-connection",
                            },
                            {
                                label: 'own_account_keyfile',
                                showOn: 'api_connection_type',
                                showOnValue: '1',
                                fields: ['own_account_keyfile'],
                                help: "google-serviceaccount-key",
                            },
                        ]
                    },
                ]
            }

        ]
    },

    {
        header: "tables_settings",
        forms: [
            {
                listForm: true,
                listFields: ["target-table"],
                field: "table-list",
                addButton: "add_table",

                formBlocks: [
                    {
                        formLines: [
                            {
                                fields: ["target-table"],
                                label: "table-destination",
                                help: "google-table-link",
                            },
                            {
                                showOn: "target-table",
                                fields: ["table-files"],
                                label: "table-files",
                                help: "google-table-file-field",
                            },
                            {
                                showOn: "table-files",
                                fields: ["table-user"],
                                label: "table-user",
                                help: "google-table-user-field",
                            },    
                            {
                                showOn: "table-files",
                                fields: ["table-time"],
                                label: "table-time",
                                help: "google-table-time-field",
                            },                                                    
                        ]
                    },
                ],
            },
        ]
    },    

];

export default composition;