import useSaveSettings from '../../hooks/useSaveSettings.js';
import useAccessTabWazzupExtensionStore from './../../store/useAccessTabWazzupExtensionStore.js';


/**
 * Таблица сопоставленных пользователей с кб
 */
export default {
  setup(props, {emit}) {
    const accessStore = useAccessTabWazzupExtensionStore();
    const metaUsers   = Vue.inject('metaUsers');
    const { t } = VueI18n.useI18n();

    return {
      accessStore,
      metaUsers,

      // сформировать имя пользователя
      getName(cbUserId) {
        let emptyValue = t('no_set');
        if (cbUserId.includes('clientbase_')) {
          cbUserId = cbUserId.substr(11);
        } else return emptyValue;

        if (metaUsers.length <= 0) return emptyValue;

        let user = metaUsers.filter(i => i.id == cbUserId)[0] || {};
        return user.fio || emptyValue;
      },

      // удалить пользователя
      deleteUser(id) {
        (new Promise((resolve, reject) => {
          resolve(accessStore.deleteUser(id));
        })).then(_ => useSaveSettings(null));
      },
    }
  },

  template: /*html*/`
    <div class="wazzup__users_list" style="margin-bottom:30px;">
      <div class="wazzup__container">
        <table class="wazzup__users_list-table">
          <caption
            style="font-size: 16px; font-weight: 600;"
          >{{ $t('Users') }}</caption>
          <tr style="border-bottom: 1px solid black;">
            <td style="width:20px;"></td>
            <td style="min-width: 200px;">{{ $t('cb_user') }}</td>
            <td>{{ $t('wazzup_user') }}</td>
          </tr>

          <tr
            v-for="user in accessStore.users"
            style="margin-bottom:15px;"
          >
            <td>
              <delete-icon
                :styles="{cursor: 'pointer', 'padding-bottom': '3px'}"
                @handle="deleteUser(user.wzId)"
              ></delete-icon>
            </td>
            <td>{{ getName(user.cbUserId) }}</td>
            <td>{{ user.wzName || $t('no_name') }}</td>
          </tr>
        </table>
      </div>
    </div>
  `
}
