import useAdditionallyTabWazzupExtensionStore from '../../store/useAdditionallyTabWazzupExtensionStore.js';
import useQueueProcessingTabWazzupExtensionStore from '../../store/useQueueProcessingTabWazzupExtensionStore.js';

export const QueueProcessing = {
  name: 'queue_processing',

  setup(props, {emit}) {
    const queueProcessing = useQueueProcessingTabWazzupExtensionStore();

    Vue.onMounted(() => {
      queueProcessing.checkConfigFile();
      checkHelpButtonsOnCurrentPage();
      bind_help_bt('wazzup');
    });

    const handleSupervisorChange = (event) => {
      queueProcessing.supervisor = event.target.checked; // Обновляем значение в хранилище
    };

    return {
      queueProcessing,
      handleSupervisorChange,
    }
  },

  template: /*html*/`
    <div class="additionally-def_chan_for_reminder">
      <div class="wazzup__supervisor">
        <label>
          <input
            type="checkbox"
            :checked="queueProcessing.supervisor"
            // :disabled="!queueProcessing.configFileExists"
            @change="handleSupervisorChange"
          />
          {{ $t('wazzup_supervisor') }}
        </label>
      </div>
    </div>
  `
}
