let viewBlock = $('#jsonObject_view');
let editBlock = $('#jsonObject_edit');
let editBtn = $('#edit-mode-btn--edit');
let addressField = $('#agentAddress');
let tokenField = $('#agentToken');

function sendConfigurationData() {
    let jsonText = $('#jsonObject_edit');
    let queryAddress = addressField.val();
    let queryToken = tokenField.val();
    let queryJSON = jsonText.val();
    let data = JSON.stringify(queryJSON);

    if (queryAddress.replace(/\s/g, '') === '') {
        fieldIsEmpty(addressField);
        return false;
    } else {
        goodValue(addressField);
    }

    if (queryToken.replace(/\s/g, '') === '') {
        fieldIsEmpty(tokenField);
        return false;
    } else {
        goodValue(tokenField);
    }

    $.ajax({
        method: "POST",
        url: queryAddress,
        data: data,
        //dataType: "json",
        async: true,
        crossDomain: true,
        xhrFields: {
            withCredentials: true
        },
        headers: { 'Authorization': 'Basic ' + queryToken },
        success: function () {
            clearRequestFields();
            showSuccessMessage();
        },
        error: function () {
            $('.server-error-msg').show();
        },
    });
}

function getInfoFromCb() {
    let addressField = $('#agentAddress');
    let tokenField = $('#agentToken');
    let jsonForm = $('#agentInfoConfig');
    let queryAddress = addressField.val();
    let queryToken = tokenField.val();

    if (queryAddress.replace(/\s/g, '') === '') {
        fieldIsEmpty(addressField);
        return false;
    } else {
        goodValue(addressField);
    }

    if (queryToken.replace(/\s/g, '') === '') {
        fieldIsEmpty(tokenField);
        return false;
    } else {
        goodValue(tokenField);
    }

    $.ajax({
        method: 'GET',
        url: queryAddress,
        async: true,
        crossDomain: true,
        xhrFields: {
            withCredentials: true
        },
        headers: { 'Authorization': 'Basic ' + queryToken },
        success: function () {
            displayConfigurationForm(jsonForm, 'someResponse');
            clearRequestFields();
        },
        error: function (data) {
            showErrorMessage(jsonForm);
        },
    });
}

function showErrorMessage(form) {
    form.hide();
    $('.server-error-msg').show();
    setTimeout(function () {
        $('.server-error-msg').hide();
    }, 3000);
}

function displayConfigurationForm(form, response) {
    form.show();
    $('.server-error-msg').hide();
    editBlock.css('height', viewBlock.height() + 32);
    editBlock.text(response);
    viewBlock.text(response);
}

function fieldIsEmpty(emptyField) {
    $(emptyField).addClass('is-invalid');
    return false;
}

function goodValue(valueField) {
    if ($(valueField).hasClass('is-invalid')) $(valueField).removeClass('is-invalid').addClass('is-valid');
}

function clearRequestFields() {
    let addressField = $('#agentAddress');
    addressField.removeClass('is-valid').removeClass('is-invalid');
    let tokenField = $('#agentToken');
    tokenField.removeClass('is-valid').removeClass('is-invalid');
}

function showSuccessMessage() {
    $('.success-msg').show();
    setTimeout(function () {
        $('.success-msg').hide();
    }, 3000);
}

function saveNewJSONValue() {
    viewBlock.text(editBlock.val());
    viewBlock.show();
    editBlock.hide();
    editBtn.text('Редактировать');
    editBtn.removeClass('edit-mode-btn--save');
    editBtn.addClass('edit-mode-btn--edit');
}

function showEditMode() {
    viewBlock.hide();
    editBlock.show();
    editBtn.text('Сохранить');
    editBtn.removeClass('edit-mode-btn--edit');
    editBtn.addClass('edit-mode-btn--save');
}