import { components as localComponents } from "../../formLine.js?v=3";
import { formBaseElement } from "../../formBaseElement.js";
import Switcher from '../../shared/Switcher/Switcher.js'
import CopyButton from '../../shared/CopyButton/CopyButton.js'
import ArchiveButton from '../../shared/ArchiveButton/ArchiveButton.js'
import DeleteButton from '../../shared/DeleteButton/DeleteButton.js'
import EditButton from '../../shared/EditButton/EditButton.js'
import AlertIcon from '../../shared/AlertIcon/AlertIcon.js'
import EditRow from './EditRow/EditRow.js'
import ListFilter from './EditFilter/EditFilter.js'
import EditListStyles from './EditListStyles.js'
import useScopedStyleMixin from '../../useScopedStyleMixin.js'

const EditList = {
  template: /*html*/`
    <section
      :class="componentClass + hash"
    >
      <ListFilter 
        v-if="filterCategories"
        :filterCategories="filterCategories"
        :element="element"
        @showActive="filter = 'active'"
        @showArchived="filter = 'archived'"
        :filter="filter"
      />
      <ul :class="componentClass + hash + '__lines'">
        <li 
          v-for="({ originIndex: index, ...rowData }) in filteredListData"
          :class="[componentClass + hash + '__line', { 'active': isActiveLine(index) }]"
        >
          <ArchiveButton 
            v-if="hasArchives"
            @click="filter === 'archived' ? removeFromArchive(index) : addToArchive(index)" 
            :index="index"
            :isFilterArchived="filter === 'archived'"
          />
          <DeleteButton
            @click="handleDeleteClick" 
            :index="index"
          />
          <CopyButton
            v-if="isCopyable"
            @click="handleCopyClick" 
            :index="index"
          />
          <Switcher
            v-if="filter === 'active' && hasActivity"
            :key="index"
            :value="rowData[activityField] === activityOptions.on" 
            :index="index"
            @update="handleActivityToggle"
          />
          <EditRow
            v-if="rowData"
            :element="element" 
            :fields="element.listFields"
            :rowData="rowData"
            :data="actualFieldsSource[field]"
            @edit="handleEditClick" 
            :index="index"
          />
          <AlertIcon
            v-if="showAlert(index)"
            :message="alertMessage(index)"
            :index="index"
          />
        </li>
      </ul>
    </section>
  `,
  name: 'edit-list',
  components: {
    ListFilter,
    EditRow,
    Switcher,
    CopyButton,
    ArchiveButton,
    DeleteButton,
    EditButton,
    AlertIcon,
    ...localComponents
  },
  mixins: [formBaseElement, useScopedStyleMixin, EditListStyles],
  data() {
    this.linesFromFields();
    this.blocksFromLines();
    return {
      names: {}, // имена для tables, groups, fields
      activeTable: 0, // id текущей таблицы для fields
      formDataSource: {},
      formStatus: "",
      editIndex: 0,
      filter: "active",
      componentClass: 'editform-list',
    }
  },
  computed: {
    isActiveLine() {
      return (index) => {
        return (this.formStatus == 'edit') && (index == editIndex)
      }
    },
    showAlert() {
      const listData = this.actualDataSource[this.field];
      return (index) => this.hasAlert && listData[index][this.alertField];
    },
    hasAlert: function() {
      const alert = this.element['alert'];
      return !!alert;
    },
    alertField: function() {
      const alert = this.element['alert'];
      if (!alert) return;

      const { field } = alert;
      return field;
    },
    alertMessage() {
      const listData = this.actualDataSource[this.field];
      return (index) => listData[index][this.alertField];
    },

    isCopyable: function() {
      const copy = this.element['copy'];
      return copy === true;
    },

    hasActivity: function() {
      const activity = this.element['activity'];
      return !!activity;
    },
    activityField: function() {
      const activity = this.element['activity'];
      if (!activity) return;

      const { field } = activity;
      return field;
    },
    activityOptions: function() {
      const activity = this.element['activity'];
      if (!activity) return;
      const { field, ...options } = activity;
      return {
        ...options 
      };
    },

    hasArchives: function() {
      const archive = this.element['archive'];
      return !!archive;
    },
    archiveField: function() {
      const archive = this.element['archive'];
      if (!archive) return;

      const { field } = archive;
      return field;
    },
    archiveOptions: function() {
      const archive = this.element['archive'];
      if (!archive) return;
      const { field, ...options } = archive;
      return { ...options };
    },
    filterCategories: function() {
      if(!this.listData || !this.hasArchives) return false;
      const defaultValue = this.archiveOptions?.default || 1;

      const archiveValues = this.listData.map(lineData => 
        lineData.hasOwnProperty(this.archiveField)
          ? Number(lineData[this.archiveField])
          : defaultValue
      );
      const uniqueValues = [ ...new Set([ ...archiveValues]) ];
      const hasArchived = uniqueValues.includes(Number(this.archiveOptions.on));
      const categories = [
        { 
          filterValue: 'active', 
          emit: 'show-active', 
          title: 'активные', 
        },
        { 
          filterValue: 'archived', 
          emit: 'show-archived', 
          title: 'архив', 
          isDisabled: !hasArchived
        },
      ]
      return categories
    },
    listData: function() {
      if(!Array.isArray(this.actualDataSource[this.field])) return;
      const listData = this.actualDataSource[this.field]
        .map((lineData, index) => ({ ...lineData, originIndex: index }));
      return listData;
    },
    filteredListData() {
      if(!this.listData) return [];
      if(!this.hasArchives) return this.listData;

      if(this.filter === 'archived')
        return this.listData.filter(lineData => 
        Number(lineData[this.archiveField]) === Number(this.archiveOptions.on)
        )
      if(this.filter === 'active')
        return this.listData.filter(lineData => 
          Number(lineData[this.archiveField]) === Number(this.archiveOptions.off) 
          || lineData[this.archiveField] === undefined
        )

      return this.listData
    },
  },
  methods: {
    handleActivityToggle(index, newIsActive) {
      const item = this.actualDataSource[this.field]?.[index];
      if(newIsActive === true)
        item[this.activityField] = this.activityOptions.on;
      else item[this.activityField] = this.activityOptions.off;
      
      this.store.save();
      this.$emit('clearForm', index);
    },
    handleEditClick(index, e) {
      this.$emit('edit', index);
    },
    handleCopyClick(index, e) {
      if (!Number.isInteger(index) || index < 0) return;
  
      const items = this.actualDataSource[this.field];

      if (!Array.isArray(items) || index >= items.length) return;

      const { id, ...item } = this.actualDataSource[this.field]?.[index] || {};
      item.name = item.name + " (копия)";
      this.$emit('add', e, item);
/*
      items.push({ 
        ...item, 
        ...(this.hasActivity ? { [this.activityField]: this.activityOptions.off } : {})
      });
      this.store.save();
      this.$emit('clearForm', index);
*/      
    },
    handleDeleteClick(index, e) {
      if (!Number.isInteger(index) || index < 0) return;
  
      const items = this.actualDataSource[this.field];
      if (!Array.isArray(items) || index >= items.length) return;

      let self = this;

      if (this.element.delete?.confirm) {
        //Если в composition указано что нужно выводить уведомление
        jconfirm(this.$t(this.element.delete.confirm), function() {
          self.delete(index);
        });        
      } else {
        this.delete(index); 
      }
    },

    delete(index) {
      const items = this.actualDataSource[this.field];
      if (this.element.delete?.linked) {
        //Если в настройках composition указано что нужно удалять связанные элементы
        const itemToDelete = items[index];
        const linkedSettings = this.element.delete.linked;
        for (const linked of linkedSettings) {
          let linkedItems = this.actualDataSource[linked.list];
          const field = linked.field;
          if (linkedItems && field) {
            const id = linked.id ?? 'id';
            this.actualDataSource[linked.list] = linkedItems.filter(item => Number(item[field]) !== Number(itemToDelete[id]));
          }
        }
      }
      items.splice(index, 1);
      this.store.save();
      this.$emit('clearForm', index);      
    },

    addToArchive(index, e) {
      const item = this.actualDataSource[this.field]?.[index];
      if (!item) return;

      item[this.archiveField] = this.archiveOptions.on;

      this.store.save();
      this.$emit('clearForm', index);
    },
    removeFromArchive(index, e) {
      const item = this.actualDataSource[this.field]?.[index];
      if (!item) return;

      item[this.archiveField] = this.archiveOptions.off;

      this.store.save();
      this.$emit('clearForm', index);
    },
  },
};

export default EditList