import { components } from "../../formLine.js?v=3";
import { formBaseElement } from "../../formBaseElement.js";
import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import FormTabStyles from './FormTabStyles.js';

const FormTab = {
  name: 'edit-form-tab',
  components: components,
  mixins: [formBaseElement, useScopedStyleMixin, FormTabStyles],

  data() {
    this.linesFromFields();
    this.blocksFromLines();
    this.formsFromBlocks();
    return {
      componentClass: 'editform-tab',
    }
  },

  template: /*html*/`
    <section
      :class="componentClass + hash"
    >
      <p v-if="element.noticeFromLang" class="editform-notice">{{$t(element.noticeFromLang)}}</p>
      <p v-if="element.noticeFromStore && this.store.notices[element.noticeFromStore]" class="editform-notice status red">{{$t(this.store.notices[element.noticeFromStore])}}</p>
      <template v-for="form in element.forms">
        <component
          v-bind:is="form.listForm ? 'edit-listform' : 'edit-form'"
          :dataSource="dataSource"
          :fieldsSource="fieldsSource"
          :element="form"
        />
      </template>
    </section>
  `
};

export default FormTab;