import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import AlertIconStyles from './AlertIconStyles.js'

const AlertIcon = {
  template: /*html*/`
    <div
      :class="componentClass + hash"
      :title="message"
    >
      <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
      <circle cx="7" cy="7" r="7" fill="#D00A1B"/>
      <path d="M7.676 4.832C7.676 5.48 7.652 6.084 7.604 6.644C7.556 7.204 7.492 7.772 7.412 8.348H6.044C5.964 7.772 5.896 7.204 5.84 6.644C5.792 6.084 5.768 5.48 5.768 4.832V2.684H7.676V4.832ZM7.832 10.052C7.832 10.404 7.716 10.676 7.484 10.868C7.26 11.06 7.004 11.156 6.716 11.156C6.428 11.156 6.168 11.06 5.936 10.868C5.712 10.676 5.6 10.404 5.6 10.052C5.6 9.7 5.712 9.428 5.936 9.236C6.168 9.044 6.428 8.948 6.716 8.948C7.004 8.948 7.26 9.044 7.484 9.236C7.716 9.428 7.832 9.7 7.832 10.052Z" fill="white"/>
      </svg>
    </div>
  `,
  props: {
    index: Number,
    message: String
  },
  data() {
    return {
      componentClass: 'alert-icon',
    }
  },
  
  mixins: [useScopedStyleMixin, AlertIconStyles],
  name: 'alert-icon',
};

export default AlertIcon;