import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import LabelStyles from './LabelStyles.js';

const Label = {
  name: 'edit-form-label',
  props: {
    label: String,
    help: String
  },
  data() {
    return {
      componentClass: 'label',
    }
  },
  mixins: [useScopedStyleMixin, LabelStyles],
  mounted() {
    bind_help_bt(false, this.help); //функция из help_sys.js
  },
  template: /*html*/`
    <label 
      :class="componentClass + hash"
    >
      {{ $t(label) }}
      <span v-if="help" class="help_bt" :id="help" :h_id="help"></span>
      :
    </label>
  `
};

export default Label;