/**
* Приложение - форма редактирования
*
*/

import components from "./components/formContainers.js?v=efv_8";
import { useEditFormStore } from './store/storeForm.js?v=efv_5';

export default function(settings) {
  return {
    components: components,

    setup() {
      const store = useEditFormStore();
      store.setFields(settings.fields);
      store.setComposition(settings.composition);

      if (settings.additional['notices']) {
        store.setNotices(settings.additional['notices']);
      }

      if (settings.moduleId) {
        store.setModule(settings.moduleId);
      }

      if (settings.data) {
        store.setData(settings.data);
      }

      if (settings.rootMode) {
        store.setRootMode(true);
      }

      const haveTabs = Object.keys(store.composition).length > 1;
      store.activeTab = store.composition[0].header || "";

      return {
        store,
        haveTabs
      }
    },

    data() {
      const initialTab = this.$hashPath.get(0);
      if (initialTab) {
        const found = this.store.composition.findIndex(item => item.header === initialTab);
        if (found !== -1) {
          this.store.activeTab = initialTab;
        }
      }
    },

    methods: {
      setActiveTab(tab) {
        this.store.activeTab = tab.header;
        this.$hashPath.set(0, tab.header);
      },

      isActiveTab(tab) {
        return (tab.header == this.store.activeTab);
      }
    },

    template: /*html*/`
    <div v-if="store.saving" class="preloader__block">
    <div class="preloader">
        <div class="lds-css ng-scope">
            <div style="width:100%;height:100%" class="lds-ellipsis">
                <div>
                    <div></div>
                </div>
                <div>
                    <div></div>
                </div>
                <div>
                    <div></div>
                </div>
                <div>
                    <div></div>
                </div>
                <div>
                    <div></div>
                </div>
            </div>
        </div>
    </div>
</div>    
      <ul v-if="haveTabs" class="editform-nav">
        <template v-for="tab in store.composition">
          <li :class="isActiveTab(tab) ? 'active' : ''">
            <a
              :href="'#' + tab.header"
              v-on:click="setActiveTab(tab)"
            >{{$t(tab.header)}}</a>
            <span v-if="tab.help" class="help_bt" :h_id="tab.help"></span>
          </li>
        </template>
      </ul>

      <template v-if="store.moduleId == 'cbext.clientbase.merchant_tinkoff'">
        <h5 class="status green" v-if="store.moduleActive == true">Модуль подключен</h5>
        <h5 class="status red" v-else>Модуль не подключен</h5>
      </template>

      <template v-for="tab in store.composition">
        <edit-form-tab 
          v-show="isActiveTab(tab)" 
          :element="tab" 
        />
      </template>
    `,
  }
}
