export default{
  name: 'kanban-modal-window',

  data() {
    return {
      text_empty_templates: lang['Templates_not_found'],
      text_additional: lang['additionally'],
      page: 1,
      error_show: false,
      error_title: lang['Attention'],
      error_text: '',
    }
  },

  props: {
    show:     { type: Boolean, default: false },
    type:     { type: String,  default: 'print' },
    table_id: { type: Number,  default: 0 },
    card_id:  { type: Number,  default: 0 },
    items:    { type: Array,   default: [] },
    hashes:   { type: Array,   default: [] },
  },

  methods: {
    async clickHandler(id, error = '') {
      if (this.type != 'sms' && error != '') {
        this.error_text = error;
        this.error_show = true;
        return;
      }

      if (this.type == 'print') {
        try {
          let response = await (await fetch(`report.php?table_id=${this.table_id}&set_sel=${this.card_id}`)).text();
          if (response == 1) {
            window.open(`forms.php?table=${this.table_id}&mode=print&form=${id}`, '_blank');
          } else {
            this.error_text = 'Произошла ошибка, попробуйте повторить процедуру';
            this.error_show = true;
          }
        } catch(e){
        }
      } else if(this.type == 'send' || this.type == 'sms') {
        try {
          let response = await (await fetch(`report.php?table_id=${this.table_id}&sel=${this.card_id}&op_sel=${this.type}&form_sel=${id}`)).text();
          if (response == 1 || response == 2) {
            let text = `${lang['Mailer_started']}. `;
            if (user.group_id == 1) {
              text += `<a style='font-size:16px;' href=edit_${response == 1 ? 'mail' : 'sms'}ing.php>${lang['Active_mailer']}</a>`;
            }

            displayNotification(text, 1);
            this.$emit('close_dialog');
          } else if (response == 3 || response == 4) {
            window.open(`forms.php?table=${this.table_id}&mode=print&form=${id}${response == 3 ? '&edit' : ''}`, '_blank');
            this.$emit('close_dialog');
          } else {
            this.error_text = 'Произошла ошибка, попробуйте повторить процедуру';
            this.error_show = true;
          }
        } catch(e) {
        }
      }
    },

    changePage(num) {
      this.page = num;
    },

    getPagesButtonsClasses(num) {
      return num == this.page ? 'form_print_switcher form_switcher form_switcher--active' : 'form_print_switcher form_switcher';
    },

    getHashName(form) {
      return Object.keys(form)[0];
    },

    getHashLink(form) {
      return form[Object.keys(form)[0]];
    },

    getMagnifierLink(form_id) {
      return `forms.php?table=${this.table_id}&mode=${this.type}&form=${form_id}&view`;
    }
  },

  computed: {
    getTitle() {
      if (this.type == 'print') {
        return lang['select_print_template'];
      } else if (this.type == 'send') {
        return lang['select_mail_template'];
      } else if (this.type == 'sms') {
        return lang['select_sms_template'];
      } else if (this.type == 'hash') {
        return lang['Gen_Hash'];
      } else {
        return '';
      }
    },

    getSettingsURL() {
      return ;
    },

    getPageItems() {
      return this.items.slice((this.page - 1) * 8, this.page * 8 - 1);
    },

    getPages() {
      let page_nums = [];
      for (let i = 1; i <= Math.ceil(this.items.length / 8); i++) {
        page_nums.push(i);
      }

      return page_nums.length < 2 ? [] : page_nums;
    },

    isAdmin() {
      return user['group_id'] == 1 ? true : false;
    },
  },

  template: /*html*/`
    <div>
      <modal-window
        :show="error_show"
        :title="error_title"
        @close_dialog="error_show = false"
      >
        <div class="error__content">{{error_text}}</div>
      </modal-window>

      <div class="templates_modal_window__items" v-if="type != 'hash'">
        <div class="templates_modal_window__items--empty" v-if="items.length == 0">
          {{ text_empty_templates }} <a :href="getSettingsURL" target="_blank">{{ text_additional }}</a>
        </div>

        <div class="templates_modal_window__items--item_group" v-for="item in getPageItems">
          <button class="templates_modal_window__items--item"  @click="clickHandler(item.id, item.warning)">
            {{ item.name_form }}
          </button>

          <a v-if="isAdmin && (type == 'send' || type == 'sms')" class="form_lupa" :href="getMagnifierLink(item.id)" target="_blank"></a>
        </div>

        <div id="form_switcher_wrapper_print">
          <button :class="getPagesButtonsClasses(num)" v-for="num in getPages" :key="num" @click="changePage(num)"></button>
        </div>
      </div>

      <div v-if="type == 'hash'" class="hashes__container">
        <div v-for="form in hashes">
          <span class="search_cell">{{getHashName(form)}}:</span>
          <input class="form-control" @focus="$event.target.select()" type="text" :value="getHashLink(form)" readonly />
        </div>
      </div>
    </div>
  `
}
