/**
 * Перевести слово используя глобальную переменную lang
 *
 * @param {string} key
 * @returns {string}
 */
export default function useTranslate(key) {
  if (typeof key !== "string") {
    return "useTranslate: variable is not a string";
  }

  if ('lang' in window) {
    return (
      key in window['lang']
        ? window['lang'][key]
        : `useTranslate: "${key}" variable not translated`
    );
  } else {
    return "useTranslate: lang variable is not declared";
  }
}
