'use strict';

import { LS } from "./ls.js";


/** Инициализация store с отслеживанием переменных состояния */
export function initStore(prefix) {
  let ls = LS(prefix);

  CB.store.register(prefix, {
    namespaced: true,

    state: () => ({
      user_status: ls.get('user_status') || {
        status: false,
        message: ''
      },
      users_info: ls.get('users_info') || [],
      service_text: ls.get('service_text') || '',
      phone_number: ls.get('phone_number') || '',
      asterisk_time: ls.get('asterisk_time') || '00:00:00',
      is_call: ls.get('is_call') || false,
      callInterval: ls.get('callInterval') || void 0,
      show_call_notification: ls.get('show_call_notification') || false,
      is_showed_call_block: ls.get('is_showed_call_block') || false,
      call_type: ls.get('call_type') || '',
      notification_info: ls.get('notification_info') || {},
      notification_text: ls.get('notification_text') || '',
      params: ls.get('params') || {},
      Call: ls.get('Call') || {},
      show_number_block: ls.get('show_number_block') || false,
      provider_settings: ls.get('provider_settings') || {},
      notification_title: ls.get('notification_title') || 'Asterisk',
      notification_title: ls.get('redirect_number') || 'redirect_number',
      goCall: false,
      needAnswerCall: false,
    }),

    getters: {},

    mutations: {
      setValue(state, { name, data } ) {
        state[name] = data;
      }
    },

    actions: {
      setValue({ commit }, { name, data, useLS }) {
        commit('setValue', { name, data });
        if (useLS) {
          ls.set(name, data);
        }
      },

      answerCall(context) {
        context.dispatch('setValue', {
          name: "needAnswerCall",
          data: true,
          useLS: true
        });
      },

      dropCall(context) {
        if(context.state.call_type == 'incoming') {
          context.dispatch("dropIncomingCall");
        } else {
          context.dispatch("dropOutgoingCall");
        }
        context.dispatch("setValue", {
          name: "is_call",
          data: false,
          useLS: true
        });
        context.dispatch("setValue", {
          name: "call_type",
          data: "",
          useLS: true
        });
      },

      dropIncomingCall(context) {
        let Call = context.state.Call;
        Call.isCall = false;
        Call['incoming'] = {};
        // Флаг для сброса звонка на той вкладке, где есть сессия входящего звонка
        Call['incoming']['dropIncomingCall'] = true;

        context.dispatch("setValue", {
          name: "Call",
          data: Call,
          useLS: true
        });

        Call['incoming'] = {};
        context.dispatch("setValue", {
          name: "Call",
          data: Call,
          useLS: true
        });
      },

      dropOutgoingCall(context) {
        context.dispatch("setValue", {
          name: "Call",
          data: {
            isCall: false,
            outgoing: {
              dropCall: true
            }
          },
          useLS: true
        });

        context.dispatch("setValue", {
          name: "Call",
          data: {
            isCall: false,
            outgoing: {}
          },
          useLS: true
        });
      }
    },

    modules: {
      /** Карточка клиента */
      notification_info: {
        namespaced: true,
        state: () => ({
          from_number: ls.get('notification_info')?.from_number || "",
          from: ls.get('notification_info')?.from || "",
          from_name: ls.get('notification_info')?.from_name || "",
          from_url: ls.get('notification_info')?.from_url || "",
          addit_1: ls.get('notification_info')?.addit_1 || "",
          addit_2: ls.get('notification_info')?.addit_2 || "",
          addit_3: ls.get('notification_info')?.addit_3 || ""
        })
      }
    }
  });
}
