/**
 * @constructor
 * @deprecated Используйте createOverlay для создания оверлея
 * @fixme Данный функционал содержит jquery и нечитаем, 
 * должен быть удален после того как перестанет использоваться
 */
function Overlay() {
    var overlay = $('.overlay');

    /**
     * Метод, добавляющий обработчики для закрытия
     * @param obj {Element} элемент, который нужно закрыть
     * @param events {Array} массив объектов, по которым нужно закрывать overlay
     * @param hide {String} метод закрытия элемента
     * @param speed {Number} скорость закрытия элемента
     */
    this.close = function(obj, events = [], hide = '', speed = 400) {
        if (typeof obj !== 'undefined' && overlay.length > 0) {
            if ($(obj).css('display') !== 'none') {
                overlay.on('click', function() {
                    this.hide(obj, hide, speed);
                    $('div[id^=add_link_block]').hide();

                    // Если кликнули не по подтаблице
                    if (!isSubtableTarget) {
                      let fieldInfo = show_fields.fields[Number(globalActiveFieldId)] || {};

                        // Вызываем клик у автокомплита после закрытия формы быстрого добавления в зависимости от режима
                        if ($('#edit_block').css('display') === 'none') {
                            if (fieldInfo['mult_value'] != '1') {
                              $(`#view_block select.combobox[field_id=${globalActiveFieldId}]`).next().find('.autocomplete__input').click();
                            }
                            return;
                        } else {
                            if (globalActiveFieldId != "") {
                              if (fieldInfo['mult_value'] != '1') {
                                $(`#edit_block select.combobox[field_id=${globalActiveFieldId}]`).next().find('.autocomplete__input').click();
                              }
                            }
                            return;
                        }

                        // В календаре
                        if ( typeof globalCalendarEventId != 'undefined')
                            $(`#record_card_add${globalCalendarEventId} select.combobox[field_id=${globalActiveFieldId}]`).next().find('.autocomplete__input').click();
                        else if ( typeof globalActiveFieldId != 'undefined' && typeof globalActiveLineId != 'undefined' )
                            $(`#sel_records .fields__cell select[field_id=${globalActiveFieldId}][line_id=${globalActiveLineId}]`).next().find('.autocomplete__input').click();
                    } else {
                        $(`.subtable select.combobox[field_id=${globalActiveFieldId}][line_id=${globalActiveLineId}]`).next().find('.autocomplete__input').click();
                        $('.subtable').css('z-index', '2');
                    }
                }.bind(this));
                $(document).keydown(function(e) {
                    if( e.keyCode === 27 ) {
                        this.hide(obj, hide, speed);
                        return false;
                    }
                }.bind(this));

                events.forEach(function (item) {
                    $(item).on('click', function() {
                        this.hide(obj, hide, speed);
                    });
                });
            }
        }
    }

    /**
     * Метод, закрывающий overlay и элемент
     * @param obj {Element} элемент, который нужно закрыть
     * @param hide {String} метод закрытия элемента
     * @param speed {Number} скорость закрытия элемента
     */
    this.hide = function(obj, hide, speed) {
        $(overlay).remove();
        switch (hide) {
            case 'slide':
                $(obj).slideUp(speed);
                break;
            default:
                $(obj).css('display', 'none');
                break;
        }
    }

    window.Overlay = Overlay;

}
/**
 * Скрывает элемент с анимацией.
 * @param {Object} params - Параметры функции.
 * @param {HTMLElement} params.element - Элемент, который нужно скрыть (HTML элемент).
 * @param {number} params.duration - Продолжительность анимации в миллисекундах.
*/
const hideElement = async ({
  element,
  duration
}) => {
  if(!duration) 
    return element.style.visibility = 'hidden';

  const slideUp = () => 
    new Promise((resolve) => {
      element.style.transition = `height ${duration}ms ease, opacity ${duration}ms ease`;
      element.style.height = `${element.scrollHeight}px`
      element.style.opacity = 1;

      setTimeout(() => {
        element.style.height = '';
        element.style.opacity = 0;
      }, 10);

      setTimeout(() => {
        element.style.visibility = 'hidden';
        resolve();
      }, duration);
    });
  await slideUp();
}
/**
 * Показывает элемент с анимацией.
 * @param {Object} params - Параметры функции.
 * @param {HTMLElement} params.element - Элемент, который нужно показать (HTML элемент).
 * @param {number} params.duration - Продолжительность анимации в миллисекундах.
*/
const showElement = async ({
  element,
  duration
}) => {
  if (!duration) {
    element.style.visibility = 'visible';
    return;
  }
 
  const slideDown = () => 
    new Promise((resolve) => {
      element.style.transition = `height ${duration}ms ease, opacity ${duration}ms ease`;
      element.style.visibility = 'visible';
      element.style.height = '0';
      element.style.opacity = 0;

      setTimeout(() => {
        element.style.height = `${element.scrollHeight}px`
        element.style.opacity = 1;
      }, 10);

      setTimeout(() => {
        element.style.height = '';
        resolve();
      }, duration);
    })

  await slideDown();
}
/**
 * Создает оверлей для всплывающего окна.
 * @returns {Object} - Объект с элементом оверлея и методом инициализации.
 * @returns {HTMLElement} returns.element - Элемент оверлея (HTML элемент).
 * @returns {Function} returns.init - Метод инициализации оверлея.
*/
const createOverlay = () => {
  const initOverlay = async ({
    element,
    beforeClose = null,
    afterClose = null,
  }) => {
    try {
      // await showElement(popupElement, duration);
      element.addEventListener(
        'click', 
        async () => {
          if (beforeClose) await beforeClose();
          element.remove();
          if (afterClose) await afterClose();
        }, 
        { once: true }
      );
    } catch (error) {
      console.error('Ошибка при показе всплывающего окна:', error);
    }
  }

  const overlayElement = document.createElement('div');
  overlayElement.classList.add('overlay');

  return { 
    element: overlayElement,
    init: async ({...handlers}) => 
      await initOverlay({ element: overlayElement, ...handlers })
  }
}
/**
 * Отображает всплывающее окно с оверлеем.
 * @param {Object} params - Параметры функции.
 * @param {HTMLElement} params.popupElement - Элемент всплывающего окна (HTML элемент).
 * @param {number} params.duration - Продолжительность анимации отображения в миллисекундах.
 * @returns {Promise<HTMLElement>} - Возвращает элемент всплывающего окна.
*/
const showPopupWithOverlay = async ({
  popupElement,
  duration
}) => {
  const isPopupVisible = popupElement.style.visibility === "visible"
  if(isPopupVisible) return;

  const catItem = $(popupElement).attr('cat-item');

  if (typeof catItem != "undefined") {
    jalert(`<a href='edit_group.php?group=${user_group_id}&cat_item=${catItem}' target="_blank">${lang.No_rights_fast_saving}</a>`);
    return;
  }

  
  const parentElement = popupElement.parentNode;
  const overlay = createOverlay();
  await showElement({ 
    element: popupElement, 
    duration
  });
  await overlay.init({
    beforeClose: () => hideElement({ 
      element: popupElement, 
      duration
    })
  })
  parentElement.append(overlay.element);

  return popupElement;
}