<?php
$cron_code = <<<'EOF'
if ($config['type'] == 'SAAS') {
    $login = sql_fetch_row(sql_select_field('saas_config', 'value', "`key` = 'login'"))[0];
} else {
    $login = substr(key_decrypt(file_get_contents($config['site_path'] . '/runtime/key.php')), 16, 14);
}

$result = sql_select_field(CALC_TABLE, 'id, name, calculate as code', "expert_mode = 1 AND table_id > 0 AND disabled = 0 AND name NOT LIKE '%_autoPHP8'");
while ($script = sql_fetch_assoc($result)) {
    $type = substr($script['name'], 0, 7) == 'Button ' ? 'button' : 'calc';
    $script['type'] = $type;
    if ($type == 'button') {
        $script['id'] = sql_fetch_row(sql_select_field(BUTTONS_TABLE, 'id', 'id = ', substr($script['name'], 7)))[0];
    }
    $all_scripts[] = $script;
}
$result = sql_select_field(CRON_TABLE, 'id, command as code', "system = 0 AND disabled = 0 AND description NOT LIKE '%_autoPHP8'");
while ($script = sql_fetch_assoc($result)) {
    $script['type'] = 'cron';
    $all_scripts[] = $script;
}
$result = sql_select_field(REPORTS_TABLE, 'id, code', "code != 'yaml' AND arc = 0 AND name NOT LIKE '%_autoPHP8'");
while ($script = sql_fetch_assoc($result)) {
    $script['type'] = 'report';
    $all_scripts[] = $script;
}
$result = sql_select_field(EXT_FILES, 'id, name', "name NOT LIKE '%_autoPHP8'");
while ($script = sql_fetch_assoc($result)) {
    $script['type'] = 'file';
    $script['code'] = file_get_contents($config['site_path'] . '/' . $script['name']);
    $all_scripts[] = $script;
}
$total = 0;
foreach ($all_scripts as $script) {
    $script_id = $script['id'];
    $type = $script['type'];
    $code = $script['code'];
    if (!$gpt_data[$type][$script_id]['readiness']) {
        $gpt_data[$type][$script_id]['readiness'] = send_gpt_prompt($login, $code, 'check_code');
        file_put_contents('temp/gpt_php8.json', json_encode_visual($gpt_data));
    }
    $total += $gpt_data[$type][$script_id]['readiness'];
}
$average = $total / count($all_scripts);
\CB\Tool\Curl::exec('http://manage.clientbase.ru/save_php8_ready.php', ['login' => $login, 'data' => $average]);

sql_delete(CRON_TABLE, 'id = 
EOF;

$cron_id = sql_insert($config['table_prefix'] . 'cron', [
    'description' => '_gpt_php8_ready_', 
    'thread_name' => 'main', 
    'period' => '* * * * *', 
    'last_start_time' => date('Y-m-d H:i:s'),
    'last_stop_time' => date('Y-m-d H:i:s'),
]);
$cron_code .= "$cron_id');";
sql_update($config['table_prefix'] . 'cron', ['command' => $cron_code], 'id = ', $cron_id);
