import View from '../view';
import {IEdit, IOption} from './edit';
import {TypeFields, getUrlVars, URL} from '../util';
import Access from '../access';

const drawNavBar = (lineId: number): string => {
    const deleteBtn: string = (Access.delete === 1 && lineId != 0) ?
        `<button type="button" id="delete-btn" class="nav-bar__btn nav-bar__btn--edit">Удалить</button>`:
        ``;
    const backBtn: string = (lineId != 0) ?
        `<button type="button" id="back-btn" class="nav-bar__btn nav-bar__btn--back">Вернуться в просмотр</button>` :
        `<button type="button" id="back-btn" class="nav-bar__btn nav-bar__btn--back">Вернуться в таблицу</button>`;
    return `<div class="nav-bar">
    <button type="button" id="save-btn" class="nav-bar__btn nav-bar__btn--save">Сохранить</button>
    ${deleteBtn}
    ${backBtn}
</div>`;
};

const getFieldByType = (fieldData: IEdit): string => {
    let field: string = ``;
    const lineId: string = getUrlVars()[`lineId`];
    if (lineId) {
        if (fieldData.type === TypeFields.SELECT ||
            fieldData.type === TypeFields.GROUP_SELECT ||
            fieldData.type === TypeFields.USER_SELECT) {
            let options:string = `<option></option>`;
            if (parseInt(lineId) !== 0) {
                const value: string|number = (fieldData.type === TypeFields.SELECT) ? fieldData.display_value.trim() : fieldData.value;
                if (typeof fieldData.options === `object`) {
                    fieldData.options.forEach((option: IOption) => {
                        const optionValue: string|number = (fieldData.type === TypeFields.SELECT) ? option.value.trim() : parseInt(option.value);
                        const selected = (optionValue === value) ? `selected` : ``;
                        options += `<option value="${option.value}" ${selected}>${option.name}</option>`;
                    });
                }
            } else if (parseInt(lineId) === 0) {
                if (typeof fieldData.options === `object`) {
                    fieldData.options.forEach((option: IOption) => {
                        options += `<option value="${option.value}">${option.name}</option>`;
                    });
                }
            }
            field = `<select name="f${fieldData.id}" id="field_${fieldData.id}" field-id="${fieldData.id}">${options}</select>`;
        } else if (fieldData.type === TypeFields.LINK) {
            const value: number|string = (parseInt(lineId) !== 0) ? fieldData.value : ``;
            const displayValue: string = (parseInt(lineId) !== 0) ? fieldData.display_value : ``;
            field = `<input type="hidden" id="hidden_field_${fieldData.id}" name="f${fieldData.id}" value="${value}">
                     <input type="text" class="autocomplete__input" id="field_${fieldData.id}" value="${displayValue}" field-id="${fieldData.id}" data-autocomplete="${URL}?get_link=${fieldData.options}" field=${fieldData.id}>`;
        } else if (fieldData.type === TypeFields.DATE) {
            const dateValue: string = (parseInt(lineId) !== 0) ? fieldData.display_value.substring(0, 10) : ``;
            field = `<input type="date" name="f${fieldData.id}" id="field_${fieldData.id}" field-id="${fieldData.id}" value="${dateValue}">`;
        } else {
            const value: string = (parseInt(lineId) !== 0) ? fieldData.display_value : ``;
            field = `<input type="text" value="${value}" name="f${fieldData.id}" id="field_${fieldData.id}" field-id="${fieldData.id}">`;
        }
    }


    return field;
};

const drawEdit = (data: Array<IEdit>, lineId: number) => {
    let rows = ``;
    data.forEach((row: IEdit) => {
        if (row.type !== TypeFields.IMAGE && row.type !== TypeFields.FILE) {
            rows += `<div class="cb-view-line__row">
    <div class="cb-view-line__key cb-view-line__key--edit">${row.name}</div>
    <div class="cb-view-line__val">
        ${getFieldByType(row)}
    </div>
</div>`;
        }
    });

    return `<form action="" id="edit-form" name="edit">
    <div class="cb-view-line">
        ${rows}
    </div>
</form>
${drawNavBar(lineId)}`;
};

export default class EditView extends View {
    private lineId: number;

    constructor(data: Array<IEdit>, lineId: number) {
        super(data);
        this.lineId = lineId;
    }

    protected get template(): string {
        return drawEdit(this.data, this.lineId);
    }
}