/**
 * Проверить, подходящий ли формат файла для GoogleDocs
 * @param {string} query
 * @returns {boolean}
 */
function googledocs_isDocable(query)
{
    let docable = ['xls', 'xlsx', 'ods', 'doc', 'docx', 'odt', 'ppt', 'pptx', 'odp', 'rtf', 'txt'];
    let ext = query.replace(/.*file=.*\.([a-z]+)&?.*$/g, '$1');
    return docable.includes(ext);
}

/**
 * Отправить запрос к API модуля googledocs
 * @param {string} query
 * @param {function} action
 * @param {string} preloader
 */
function googledocs_sendRequest(query, action, preloader = '')
{
    if (preloader == 'doc') {
        $("#googledocs-editor-content").hide();
        $("#googledocs-editor .preloader").show();
        $("#googledocs-editor").show();
    }
    $.ajaxSetup({
        headers : {
        'X-Auth-Token' : CB.globals.x_auth_token || window.x_auth_token
        }
    });
    $.getJSON('./api/dev/cbext/clientbase/googledocs/' + query, action);
}

/**
 * Возвращает html-код ссылки с иконкой на операцию по работе с документом
 * @param {string} operation
 * @returns {string}
 */
function googledocs_getOperationLink(operation)
{
    let icon = "", title="";
    switch (operation.operation) {
        case "reader":
            icon = "b_view";
            title = lang.View2;
            break;
        case "writer":
            icon = "b_edit";
            title = lang.Edit;
            break;
        case "createcopy":
            icon = "b_copy";
            title = lang.Copy_and_edit;
            break;
    }
    let content = '<a href="" title="' + title + '" onmouseup="event.stopPropagation();" class="googledocs-open googledocs-open-' + operation.operation + '" data-query="' + operation.url + '">';
    content = content + '<img src="images/' + icon + '.png" />';
    content = content + '</a>'
    return content;
}
/**
 * Вывести панель выбора действия рядом со ссылкой на файл или с кнопкой "Добавить" в поле типа Файл
 * Возвращает jQuery-элемент созданной панели
 * @param {object} target
 * @param {text} content
 * @returns {object}
 */
function googledocs_showFileFieldPanel(targetlink)
{
    if (!targetlink.attr("googledocs-loading")) {
        
        targetlink.attr("googledocs-loading", true);

        var href = targetlink.attr("href");
        var query = href.split("?")[1];    

        if (googledocs_isDocable(query)) {
    
            let span = targetlink.next("span, a.file-cell__btn_delete, .share-panel"),
                target = '',
                viewmode = false;
            if (span.length) {
                target = span;
            } else {
                target = targetlink;
                viewmode = true;
            }

            let panel = target.nextAll(".googledocs-panel");
            if (!panel.length) {
                panel = $("#googledocs-panel-source > .googledocs-panel").clone();
                panel.addClass("googledocs-panel-file");
                target.after(panel);
                targetlink.addClass("googledocs-pre-panel");
            }

                panel.html('<img src="images/indicator.gif">');
                googledocs_sendRequest('check?' + query, (json) => {
                    let content = '';
                    if (json.links) {
                        json.links.forEach(function(operlink) {
                            if (!viewmode || (operlink.operation=='reader')) {
                                content = content + googledocs_getOperationLink(operlink);
                            }
                        });
                    }
                    if (json.id) {
                        targetlink.attr("googledocs-link", json.id);
                    }
                    panel.html(content);
                    targetlink.removeAttr("googledocs-loading");
                });
        
            return panel;

        }
    }
}

/**
 * Периодическая проверка активности редактирования
 * На сервере хранится время последнего изменения Google-документа
 * Если документ не менялся 20 минут, запрос возвращает 0 и закрываем документ.
 * Если документ редактируют - откладываем следующую проверку на 5 минут
 */
function googledocs_isActiveWriter()
{
    let docId = $("#googledocs-editor").attr("doc-id"),
        operation = $("#googledocs-editor").attr("doc-operation");

    if (docId && (operation == 'writer')) {
        googledocs_sendRequest('activewriter?docid=' + docId, function(json) {
            if (json.result) {
                setTimeout(googledocs_isActiveWriter, 30000);
            } else {
                googledocs_closeDocWindow();
                jalert(lang.Document + " \"" + json.name + "\" " + lang.saved_auto_timeout);
            }
        });
    }
}

/**
 * Вывод окна редактирования/просмотра документа
 * @param {string} query
 */
function googledocs_showDoc(query)
{
    let iframe = $("#googledocs-editor iframe"), hasIframe = iframe.length;
    $("#googledocs-editor").attr("doc-id", "");
    if (hasIframe) {
        iframe.attr("src", "");
    }
    googledocs_sendRequest(query, function(json) {
        if (json.result && (json.id || json.google_id)) {
            if (json.operation == 'writer') {
                googledocs_saved = false;
                $("#googledocs-editor-save").show();
                setTimeout(googledocs_isActiveWriter, 30000);
            } else {
                googledocs_saved = true;
                $("#googledocs-editor-save").hide();
            }
            $("#googledocs-editor")
                .attr("doc-id", json.id)
                .attr("google-id", json.google_id)
                .attr("doc-is-new", json.new)
                .attr("doc-operation", json.operation)
                .show();
            if (hasIframe) {
                iframe.attr("src", json.link);
            } else {
                window.open(json.link);                
            }
            $("#googledocs-editor .preloader").hide();
            $("#googledocs-editor-content").show();
        } else {
            $("#googledocs-editor").hide();
            jalert(json.message);
        }
    }, 'doc');
}

/**
 * Закрытие окна документа
 * Если был создан новый документ - перезагружаем страницу (чтобы новый файл отобразился в поле с файлами)
 */
function googledocs_closeDocWindow()
{
    let editor = $("#googledocs-editor");
    if (editor.attr("doc-is-new")) {
        $("#googledocs-editor").attr("doc-operation", "reload");
        location.reload();
    } else {
        $("#googledocs-editor").attr("doc-id", "").hide();
    }
}

/**
 * Закрыть окно документа
 */
function googledocs_closeDocAction()
{
    let editor = $("#googledocs-editor"),
    docId = editor.attr("doc-id"),
    googleId = editor.attr("google-id");
    editor.attr("doc-id", "");
    if (docId || googleId) {
        googledocs_sendRequest("close?id=" + docId + "&google_id=" + googleId, function(json) {
            googledocs_closeDocWindow();
        }, 'doc');
    } else {
        googledocs_closeDocWindow();
    }
}
function googledocs_closeDoc()
{
    if (googledocs_saved) {
        googledocs_closeDocAction();
    } else {
        jconfirm(lang.Confirm_close_unsaved, googledocs_closeDocAction);
    }        
}

/**
 * Сохранить документ и закрыть окно
 */
function googledocs_saveDoc()
{
    var docId = $("#googledocs-editor").attr("doc-id");
    if (docId) {
        jconfirm(lang.Confirm_save_file + '<br><br><img src="./modules/clientbase/googledocs/assets/warning-autosave.png" style="max-width: 420px;" />', function() {
            $("#googledocs-editor-content").hide();
            $("#googledocs-editor .preloader").show();
            $("#googledocs-editor").attr("doc-id", "");
            //setTimeout(function() {
                googledocs_sendRequest('save?docid=' + docId, function(json) {
                    if (json.result && json.id && json.name) {
                        googledocs_renameFile(json.id, json.name);
                        googledocs_saved = true;
                        googledocs_closeDocWindow();
                    } else if (json.message) {
                        googledocs_saved = true;
                        $("#googledocs-editor").attr("doc-is-new", "");
                        googledocs_closeDocWindow();                     
                        jalert(json.message);
                    }
                }, 'doc');
            //}, 5000);
        });
    } else {
        googledocs_saved = true;
        googledocs_closeDocWindow();
    }
}

/**
 * Изменить имя файла в поле типа файл
 * @param {string} id
 * @param {string} name
 */
function googledocs_renameFile(id, name)
{
    let linkId = "*[googledocs-link='" + id + "']";
    let panel = $(linkId + " + .googledocs-panel, " + linkId + " + * + .googledocs-panel");

    let link = $(linkId);
    if (link.length) {
        let href = link.attr("href");
        href = href.replace(/&file=.+$/g, '&file=' + name);
        href = href.replace(/&file=.+&$/g, '&file=' + name + '&');
        link.text(name);
        link.attr("href", href);
        if (link.attr("title")) {
            link.attr("title", name);
        }
    }

    panel.find("a").each(function() {
        let query = $(this).attr("data-query");
        if (query) {
            query = query.replace(/&file=.+$/g, '&file=' + name);
            $(this).attr("data-query", query);
        }
    });
}

/**
 * Добавить панель создания документа к кнопке "Добавить"
 */
function googledocs_createNewPanel(target, fieldId, lineId, fieldSource) {
    let query = "field=" + fieldId + "&line=" + lineId,
        fileSettings = fieldSource["type_value"],
        fileTypes = fileSettings.split("|")[0];

    panel = $("#googledocs-panel-source > .googledocs-panel").clone();
    panel.addClass("googledocs-panel-new");
    target.after(panel);
    target.addClass("googledocs-pre-panel");

    let content = '';
    if (!fileTypes || /doc/i.test(fileTypes)) {
        content = content + '<a href="#" title="' + lang.Create + ' ' + lang.document + '" class="googledocs-open googledocs-new googledocs-new-docx" data-query="create?' + query + '&type=docx"><img src="./modules/clientbase/googledocs/assets/icons/document.svg"></a>';
    }
    if (!fileTypes || /xls/i.test(fileTypes)) {
        content = content + '<a href="#" title="' + lang.Create + ' ' + lang.table_r + '" class="googledocs-open googledocs-new googledocs-new-xlsx" data-query="create?' + query + '&type=xlsx"><img src="./modules/clientbase/googledocs/assets/icons/spreadsheet.svg"></a>';
    }
    if (!fileTypes || /ppt/i.test(fileTypes)) {
        content = content + '<a href="#" title="' + lang.Create + ' ' + lang.presentation_r + '" class="googledocs-open googledocs-new googledocs-new-pptx" data-query="create?' + query + '&type=pptx"><img src="./modules/clientbase/googledocs/assets/icons/presentation.svg"></a>';
    }
    panel.html(content);

    return panel;
}

//Добавляем кнопки создания к "Добавить" в подтаблице
function googledocs_activateAddOnSubtable(target = null) {
    if (!target) {
        target = $(".sub_fast_edit_file_url");
    }
    target.each(function() {      
        var target = $(this).find(".sub_fast_edit_file_form_text");
        let panel = target.next(".googledocs-panel");
        if (!panel.length) {
            let actionData = $(this).attr("id");
            let checkAction = /^add_file_url_([0-9]+)_([0-9]+)_\d+$/g;                    
            if (checkAction.test(actionData)) {
                let fieldId = actionData.replace(checkAction, '$1'),
                lineId = actionData.replace(checkAction, '$2');
                googledocs_createNewPanel(target, fieldId, lineId, cur_subtable['show_fields'][fieldId]);
            }
        }
    });
}

//Добавляем кнопки создания к "Добавить" на странице таблицы и в записи
function googledocs_activateAddOnTable(onTable = false) {
    $("*[onClick^='saveNewFile'], *[onClick^='addNewFile']").each(function() {            
        var target = $(this);
        let panel = target.next(".googledocs-panel");
        if (!panel.length) {
            var actionData = target.attr("onclick");
            let checkAction = /^.+NewFile\((\d+)[^\d]*,[^\d]*(\d+).+$/g;
            if (checkAction.test(actionData)) {
                let fieldId = actionData.replace(checkAction, '$1'),
                lineId = actionData.replace(checkAction, '$2');
                let field = onTable ? search_fields["i" + fieldId] : show_fields["fields"][fieldId];
                googledocs_createNewPanel(target, fieldId, lineId, field);
            }
        }
    });
}

var googledocs_saved = true;

$(function() {

    $("#googledocs-editor-save").text(lang.Save);
    $("#googledocs-editor-close").text(lang.Cancel);

    var googledocs_isMobile = /iPhone|iPad|iPod|Android/i.test(navigator.userAgent);

    if (googledocs_isMobile) {
        $("#googledocs-editor iframe").replaceWith('<div class="googledocs-editor-message">' + lang.Document_opened_new_window + '</div>');
    }
    //Активируем кнопки "Добавить" на странице viewline
    if (typeof calc !== 'undefined') {
        calc.calcFunctions.push(googledocs_activateAddOnTable);
    }

    //Активируем кнопки "Добавить" в подтаблице - вариант активации при загрузке
    /*
    if (typeof subtableCalc !== 'undefined') {
        subtableCalc.calcFunctions.push(googledocs_activateAddOnSubtable);
    }
    */

    //Активируем кнопки "Добавить" в таблице
    if (typeof search_fields !== 'undefined') {
        googledocs_activateAddOnTable(true);
    }

    //Активируем кнопки "Добавить" в подтаблице при наведении - для вновь создаваемых записей
    $(document).on("mouseenter", ".sub_fast_edit_file_url", function() {
        googledocs_activateAddOnSubtable($(this));
    });

    /**
     * Наведение на ссылку на скачивание файла
     */
    $(document).on("mouseenter", ".user-data__file-wrap", function(event) {
        if (event.target === event.currentTarget) {
            let link = $(this).find("a[href^='open_file.php?']");
            if (link.length) {
                googledocs_showFileFieldPanel(link);
            }
        }
    });

    $(document).on("mouseleave", ".user-data__file-wrap", function(event) {
        if (event.target === event.currentTarget) {
            $(this).find(".googledocs-panel-file").remove();
        }
    });    
    
    $(document).on("mouseenter", "a[href^='open_file.php?']", function() {
        googledocs_showFileFieldPanel($(this));
    });

    /**
     * Клик на открытие документа
     */
    $(document).on("click", ".googledocs-open", function(event) {
        event.stopPropagation();
        let query = $(this).attr("data-query");
        googledocs_showDoc(query);
        return false;
    });

    $(document).on("mouseup", ".googledocs-open", function(event) {
        event.stopPropagation();
    });

    /**
     * Клик на сохранение документа
     */
    $(document).on("click", "#googledocs-editor-save", function() {
        googledocs_saveDoc();
    });

    /**
     * Закрываем окно документа по Escape
     */
    $(document).on('keydown', function(e) {
        if((e.key==="Escape") && $("#googledocs-editor").is(":visible")) {
            googledocs_closeDoc();
        }
    });

    /**
     * Уведомление при закрытии браузера если открыт документ на редактирование
     */
    $(window).on("beforeunload", function() {
        let editor = $("#googledocs-editor");
        if (editor.is(":visible") && editor.attr("doc-id") && (editor.attr("doc-operation") == 'writer')) {
            return lang.Confirm_close_unsaved;
        }
    });

});
