/**
 * Вывести панель выбора действия рядом со ссылкой на файл или с кнопкой "Добавить" в поле типа Файл
 * Возвращает jQuery-элемент созданной панели
 * @param {object} target
 * @param {text} content
 * @returns {object}
 */
function share_showFileFieldPanel(targetlink)
{
    if (!targetlink.attr("share-loading") && !targetlink.attr("share-loaded")) {
        targetlink.attr("share-loading", true);

        var href = targetlink.attr("href");
        var query = href.split("?")[1];  
        
        const queryParams = new URLSearchParams(query);
        const fieldId = queryParams.get('field');        
        const fileName = queryParams.get('file');

        if (share_isShared(fieldId)) {
            let span = targetlink.next("span, a.file-cell__btn_delete, a.delete_image_button_x"),
                target = '';

            if (span.length) {
                target = span;
            } else {
                target = targetlink;
            }

            panel = $("#share-panel-source > .share-panel").clone();
            panel.addClass("share-panel-file");
            panel.attr("id", share_generateId(fieldId, fileName));
            target.after(panel);
            targetlink.addClass("share-pre-panel");

            panel.html('<img src="images/indicator.gif">');
            share_sendRequest('check?' + query, (json) => {
                let content = '';
                if (json.link) {
                    content = '<a href="' + json.link + '" target="_blank" class="cbext-share-link" data-file="' + json.file + '" data-field="' + json.field + '" data-table="' + json.table + '"  data-line="' + json.line + '"></a>';
                }
                const panelId = share_generateId(json.field, json.file);
                const panel = $("#" + panelId);
                panel.html(content);
                targetlink.removeAttr("share-loading");
                targetlink.attr("share-loaded", true);
            });
        
            return panel;

        }
    }
}

function share_generateId(fieldId, fileName) {
    const result = btoa(unescape(encodeURIComponent(fieldId + fileName)))
        .replace(/=/g, '')
        .replace(/\+/g, '-')
        .replace(/\//g, '_');
    return result;
}

function share_isShared(fieldId)
{
    //Если при загрузке страницы не удалось получить список полей, принудительно проверяем
    if (window.cbext_share_fields === false) {
        return true;
    } else {
        if (window.cbext_share_fields.includes(fieldId)) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * Отправить запрос к API модуля share
 * @param {string} query
 * @param {function} action
 * @param {string} preloader
 */
function share_sendRequest(query, action, path = './api/dev/cbext/clientbase/share/')
{
    $.ajaxSetup({
        headers : {
        'X-Auth-Token' : CB.globals.x_auth_token || window.x_auth_token
        }
    });
    $.getJSON(path + query, action);
}


$(function() {

    window.cbext_share_fields = false; 

    /**
     * Загрузка настроек модуля, чтобы знать для каких полей разрешено
     */
    share_sendRequest('', function(data) {

        if (data?.data?.attributes?.value) {
            window.cbext_share_fields = data.data.attributes.value.tables 
            ? data.data.attributes.value.tables.flatMap(table => 
                [...(table.files || []), ...(table.images || [])]
              )
            : [];
        }

    }, "./api/dev/settings/cbext.clientbase.share");

    /**
     * Наведение на ссылку на скачивание файла
     */
    $(document).on("mouseenter", ".user-data__file-wrap", function(event) {
        if (event.target === event.currentTarget) {
            let link = $(this).find("a[href^='open_file.php?']");
            if (link.length) {
                share_showFileFieldPanel(link);           
            }
        }
    });
 
    $(document).on("mouseenter", "a[href^='open_file.php?']", function() {
        share_showFileFieldPanel($(this));
    });

    $(document).on("click", ".cbext-share-link", function(e) {
        e.stopPropagation();
        e.preventDefault();
    
        const text = $(this).attr("href");

        if (navigator.clipboard && window.isSecureContext) {
            navigator.clipboard.writeText(text);
            displayNotification(`Ссылка на файл скопирована`, 1);
        } else {
			const textArea = document.createElement("textarea");
			textArea.value = text;
			textArea.style.position = "fixed";
			textArea.style.opacity = "0";
			document.body.appendChild(textArea);
			textArea.focus();
			textArea.select();
			try {
				document.execCommand('copy');
                displayNotification(`Ссылка на файл скопирована`, 1);
			} catch (err) {
                window.open(text);
			}			
			document.body.removeChild(textArea);
        }
        
        share_sendRequest("log?file=" + $(this).attr("data-file") + "&field=" + $(this).attr("data-field") + "&table=" + $(this).attr("data-table") + "&line=" + $(this).attr("data-line"), function(json) {});
        
        return false;
    });

});