import { components } from "../../formLine.js?v=3";
import { formBaseElement } from "../../formBaseElement.js";
import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import ListFormStyles from './ListFormStyles.js';

const ListForm = {
  name: 'edit-listform',

  components: components,

  mixins: [formBaseElement, useScopedStyleMixin, ListFormStyles],

  data() {
    this.linesFromFields();
    this.blocksFromLines();
    return {
      names: {}, // имена для tables, groups, fields
      activeTable: 0, // id текущей таблицы для fields
      formDataSource: {},
      formStatus: "",
      editIndex: 0,
      componentClass: 'editform-form',
    }
  },
  mounted() {
    let initialItem = this.$hashPath.get(1);
    if (initialItem) {
      if (initialItem == "add") {
        this.flushForm("add");
      } else {
        initialItem = Number(initialItem);
        const unwatch = this.$watch("actualDataSource." + this.field, (newVar) => {
          if (newVar) {
            const found = newVar.findIndex(item => item.id === initialItem);
            if (found !== -1) {
              this.edit(found);
            }
            unwatch();
          }
        }, { immediate: true });
      }
    }
  },
  provide() {
    return { formDataSource: Vue.reactive(this.formDataSource) }; // Если уже реактивный
  },
  methods: {
    //Меняем состояние формы
    flushForm(formStatus="", editIndex=0, newData) {
      this.formDataSource = {};
      this.formStatus = formStatus;
      this.editIndex = editIndex;
      
      if (newData) {
        Object.assign(this.formDataSource, newData);
      }

      //При открытии формы добавления заполняем поля значениями по-умолчанию
      if (formStatus == "add") {
        this.$hashPath.set(1, "add");
        for (var fieldId in this.formFieldsSource) {
          if (this.formDataSource[fieldId]) {
            continue;
          }
          if (this.formFieldsSource[fieldId]['is_list_name']) {
            //Поле с названием элемента в списке, по-умолчанию ставим значение "Элемент номер"
            this.formDataSource[fieldId] = this.generateNewName(fieldId);
          } else if (this.formFieldsSource[fieldId]['default']) {
            this.formDataSource[fieldId] = this.formFieldsSource[fieldId]['default'];
          } else if ((this.formFieldsSource[fieldId]['type'] == 'checkbox') && this.formFieldsSource[fieldId]['options']) {
            this.formDataSource[fieldId] = [];
          }
        }        
      } else if (formStatus == "edit") {
        this.$hashPath.set(1, newData['id']);
      } else {
        this.$hashPath.set(1, "");
      }      
    },
    //Название для нового элемента по-умолчанию в формате "Элемент номер"
    generateNewName(fieldId) {
      //Префикс берем из перевода по содержимому параметра list-name
      let prefix = this.$t(this.formFieldsSource[fieldId]['is_list_name']);
      //Определяем очередной номер
      let num = Array.isArray(this.actualDataSource[this.field]) ? (this.actualDataSource[this.field].length + 1) : 1;
      //Проверяем, если с таким названием уже есть - добавляем 1
      while (true) {
        if (!this.actualDataSource[this.field].find((item) => item[fieldId] == prefix + " " + num)) {
          break;
        }
        num++;
      }
      return prefix + " " + num;        
    },
    //Показать форму редактирования элемента
    edit(index) {
      if(index == undefined || !this.actualDataSource[this.field][index])
        return;
      this.flushForm("edit", index, this.actualDataSource[this.field][index]);
      return false;
    },
    //Удалить элемент
    clearForm (index) {
      if(!index) return;
      if ((this.formStatus == "edit") && (this.editIndex == index)) {
        this.flushForm();
      }
    },
    //Показать форму добавления элемента
    add(e, newData = {}) {
      console.log("in add");
      e.preventDefault();
      this.flushForm("add", 0, newData);
      return false;
    },
    //Добавить-изменить элемент (submit формы)
    save(e) {
      e.preventDefault();
      
      if (this.formStatus) {
        //TODO: проверка заполнения обязательных полей
        if (this.formStatus == "add") {
          if (!this.actualDataSource[this.field] || !this.actualDataSource[this.field].length) {
            this.actualDataSource[this.field] = [];
          }
          
          this.actualDataSource[this.field].push(Object.assign({

          }, this.formDataSource));
        }

        if (this.formStatus == "edit") {
          this.actualDataSource[this.field][this.editIndex] = Object.assign({}, this.formDataSource);
        }

        this.flushForm();
        this.store.save();
      }

      return false;
    },

    //Скрываем форму по кнопке "Отмена"
    reset(e) {
      e.preventDefault();
      this.flushForm();
    },

  },
  template: /*html*/`
    <template v-if="showOn">
      <div v-if="toggleLink" class="editform-toggle">
        <a 
          href="#" 
          @click="toggle" 
          :class="hidden ? '' : 'open'"
        >
          {{ $t(toggleLink) }}
        </a>
      </div>

      <section :class="componentClass + hash" v-if="toggleShow">
        <h3 
          :class="componentClass + '__header' + hash"
          v-if="element.header"
        >
          {{$t(element.header)}}
        </h3>
        <edit-list 
          v-if="!formStatus"
          :element="element"
          @edit="edit"
          @clearForm="clearForm"
          @add="add"
        />
        <button
          v-if="!formStatus"
          :class="'btn btn-default'"
          @click="add($event)"
        >
          {{ $t(element.addButton ? element.addButton : 'editform_button_add') }}
        </button>
        <section
          v-if="formStatus"
          :class="componentClass + '__form-wrapper' + hash"
        >
          <form 
            @submit="save" 
            @reset="reset" 
            :class="componentClass + '__form' + hash"
          >
            <edit-form-block 
              v-for="block in element.formBlocks" 
              :dataSource="formDataSource" 
              :fieldsSource="formFieldsSource" 
              :element="block" 
            />
            <section 
              :class="componentClass + '__buttons' + hash"
            >
              <input 
                type="submit" 
                class="btn btn-default"  
                :value="(formStatus == 'edit') 
                  ? $t('editform_button_save') 
                  : $t('editform_button_add')" 
              />
              <input 
                type="reset" 
                class="btn btn-default" 
                :value="$t('editform_button_cancel')"
              />
            </section>
          </form>
        </section>
        

        <div v-if="element.drafts">
          <h3 v-if="element.drafts.header">
            {{$t(element.drafts.header)}}
          </h3>
          <template v-for="(draft, index) in actualDataSource[element.drafts.source]">
            <div 
              :class="'editform-formline'" 
              style="font-size: 14px;"
            >
              <a 
                href="#" 
                @click="add($event, draft)" 
                :title="'Создать такую интеграцию'"
              >
                <b style="color: green;font-size: 20px;">+</b>
              </a>
              <span>{{draft.name}} ({{draft.description}})</span>
            </div>
          </template>
        </div>
      </section>
    </template>
  `
};

export default ListForm;