const hashPathPlugin = {
    install(app, options) {
        // Получаем текущий хеш и разбиваем на части
        const getParts = () => {
            const hash = window.location.hash.replace(/^#/, '');
            return hash.split('/').filter(part => part !== '');
        };

        // Метод для получения компонента по индексу
        const get = (index) => {
            const parts = getParts();
            return parts[index] || null;
        };

        // Метод для установки компонента по индексу
        const set = (index, componentName) => {
            const parts = getParts();
            
            // Если индекс больше текущей длины, заполняем промежуточные позиции пустыми строками
            while (parts.length <= index) {
                parts.push('');
            }
            
            // Устанавливаем значение по индексу
            parts[index] = componentName;
            
            // Формируем новый хеш, фильтруя пустые части
            const newHash = parts.filter(part => part !== '').join('/');
            window.location.hash = newHash;
            
            return newHash;
        };

        // Добавляем методы в глобальные свойства приложения
        app.config.globalProperties.$hashPath = {
            get,
            set,
            getFullPath: () => getParts().join('/'),
            getPathArray: getParts
        };
    }
};

// Экспортируем плагин по умолчанию
export default hashPathPlugin;
