import CopyIcon from '../Icons/CopyIcon.js'
import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import CopyButtonStyles from './CopyButtonStyles.js';

const CopyButton = {
  template: /*html*/`
    <button
      :class="componentClass + hash"
      @click="onClick" 
      :title="$t('editform_button_copy')"
    >
      <CopyIcon />
    </button>
  `,
  props: {
    index: Number,
  },
  data() {
    return {
      componentClass: 'copy-button',
    }
  },
  mixins: [useScopedStyleMixin, CopyButtonStyles],
  name: 'copy-button',
  components: {
    CopyIcon
  },
  methods: {
    onClick(e) {
      e.preventDefault();
      this.$emit('click', this.index, e);
    },
  },
};

export default CopyButton;