/**
* Хранилище настроек и данных формы
*/
export const useEditFormStore = Pinia.defineStore('editFormStore', {
  actions: {
    setFields(fields) {
      this.fields = fields;
    },

    setComposition(composition) {
      this.composition = composition;
    },

    setNotices(notices) {
      this.notices = notices || {};
    },

    getNotice(noticeId) {
      if (this.notices[noticeId]) {
        return this.notices[noticeId];
      } else {
        return noticeId;
      }
    },

    setRootMode(set) {
      this.rootMode = set;
    },

    isRoot() {
      return this.rootMode;
    },

    setDefaultValues(data, fields) {
      for (var fieldId in fields) {
        if (data[fieldId]) {
          continue;
        }

        if (fields[fieldId]['default']) {
          data[fieldId] = fields[fieldId]['default'];
        } else if ((fields[fieldId]['type'] == 'checkbox') && fields[fieldId]['options']) {
          data[fieldId] = [];
        }

        for (var subFieldId in fields[fieldId]) {
          if (fields[fieldId][subFieldId]['type']) {
            data[fieldId] = {};
            this.setDefaultValues(data[fieldId], fields[fieldId]);
          }
        }
      }
    },

    setData(data) {
      this.data = data || {};

      if (this.fields) {
        this.setDefaultValues(this.data, this.fields);
      }
    },

    async setModule(moduleId, loadSettings=true) {
      this.moduleId = "cbext." + moduleId.replace("/", ".");
      this.modulePath = moduleId.replace(".", "/");
      this.apiPath = "./api/dev/settings/" + this.moduleId;

      if (loadSettings) {
        this.loadModuleSettings();
      }
    },

    async api(method, body) {
      let response = await fetch(this.apiPath, {
        method: method,
        credentials: "include",
        headers: {
          'X-Auth-Token' : window.x_auth_token || null,
          'Content-Type': 'application/vnd.api+json'
        },
        body: body
      });

      response = await response.json();
      return response;
    },

    save() {
      //Сохранение настроек модуля
      if (this.moduleId) {
        this.saveModuleSettings();
      }
    },

    async loadModuleSettings() {
      let response = await this.api('GET');
      if (response?.data?.attributes?.value['secret-key']) {
        this.moduleActive = true
      }
      this.setData(response?.data?.attributes?.value);
    },

    async fileToBase64(file) {
      return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onload = () => resolve(reader.result.split(',')[1]);
        reader.onerror = reject;
        reader.readAsDataURL(file);
      });
    },

    async prepareDataToSave(data) {
      if (data instanceof File) {
        return {
          _isFile: true,
          name: data.name,
          size: data.size,
          type: data.type,
          lastModified: data.lastModified,
          content: await this.fileToBase64(data),
        };
      }
    
      if (Array.isArray(data)) {
        const processedArray = [];
        for (let i = 0; i < data.length; i++) {
          processedArray[i] = await this.prepareDataToSave(data[i]);
        }
        return processedArray;
      }
    
      if (typeof data === 'object' && data !== null) {
        const processedObj = {};
        const keys = Object.keys(data);
        for (const key of keys) {
          processedObj[key] = await this.prepareDataToSave(data[key]);
        }
        return processedObj;
      }
    
      return data;
    },    

    async saveModuleSettings() {
      this.saving = true;
      let dataToSend = await this.prepareDataToSave(this.data);
/*
      //Обрабатываем файлы - преобразовываем в объект с base64
      for (const key of Object.keys(dataToSend)) {
        const value = dataToSend[key];
        console.log("datatosend: ", key);
        if (value instanceof File) {
          console.log("Its File!");
          dataToSend[key] = {
            _isFile: true,
            name: value.name,
            size: value.size,
            type: value.type,
            lastModified: value.lastModified,
            content: await this.fileToBase64(value),
          };
        }
      }
*/

      let data = JSON.stringify({
        data: {
          type: 'settings',
          id: this.moduleId,
          attributes: { value: dataToSend }
        }
      }, null, 4);

      let response = await this.api('PATCH', data);

      if (response?.data?.attributes?.value) {
        this.setData(response?.data?.attributes?.value);
        this.moduleActive = true
        displayNotification(lang.Settings_have_been_saved, 1);
      } else {
        displayNotification(lang.Error_settings_not_saved, 2);
      }
      this.saving = false;
    }
  },

  state: () => ({
    //Список всех полей формы с параметрами
    fields: {},

    //Данные формы
    data: {},

    activeTab: "First Tab",

    //Структура формы
    //Страницы-закладки
    composition: {},

    //Уведомления
    notices: {},

    moduleId: "",

    modulePath: "",

    moduleApiPath: "",


    moduleActive: "false",

    //Признак получения данных конфигурации по API без учета прав доступа
    rootMode: false,

    //Признак того что идет сохранение данных
    saving: false

  }),
});
