//
// Хранилище списка блоков пользовательского экрана
//

export const useBlocksStore = Pinia.defineStore('blocksStore', () => {
  const blockList = Vue.ref([])
  const new_block = Vue.ref({})

  const getBlock = Vue.computed( () => (id) => {
    return blockList.value.find(item => item.id == id)
  })

  function addBlock() {
    blockList.value.push({
      id: new_block.value.id || Math.floor(Math.random() * 1000000),
      block: new_block.value.block || 'cb-block-text',
      ...new_block.value
    })
  }

  function delBlock(id) {
    blockList.value = blockList.value.filter(item => item.id != id)
  }

  return {
    blockList,
    new_block,
    getBlock,
    addBlock,
    delBlock,
  }
})
