'use strict'

import { CallWindow } from '../Vue/Components/CallWindow.js';
import { addScript, createElement } from './common.js';
import { initStore } from '../Vue/scripts/store.js';
import storeFunctions from '../Vue/Mixins/StoreFunctions.js';


document.addEventListener('DOMContentLoaded', async function(){
  await addScript('./libs/crypto.js');
  await addScript('./libs/jssip-3.9.1.js');

  createElement('audio', {id: 'localAudio', autoPlay: true, muted: true}, document.body, 'append');
  createElement('audio', {id: 'remoteAudio', autoPlay: true}, document.body, 'append');
  createElement('audio', {id: 'sounds', autoPlay: true}, document.body, 'append');

  initStore(window.telephony_options.prefix);

  Vue.createApp(CallWindow(window.telephony_options))
    .mixin(storeFunctions(window.telephony_options.prefix))
    .use(CB.store.useStore())
    .mount('#callWindow');


  setInterval(_ => {
    let store = localforage.createInstance({
      name: "clientbase"
    });

    let current = new Date((new Date()).getTime() + 60000);
    store.setItem('telephony_window_time', current).then(time => {
      // console.log(time);
    });
  }, 30000);
});
